/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.feld.Bezeichner;
import gdv.xport.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FeldReferenz {
    private static final Logger LOG = LogManager.getLogger(FeldReferenz.class);
    private final String id;
    private final Bezeichner bezeichner;
    private final String bemerkung;
    private final String auspraegung;

    public FeldReferenz(XMLEventReader parser) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement(parser));
    }

    public FeldReferenz(XMLEventReader parser, StartElement element) throws XMLStreamException {
        this.id = element.getAttributeByName(new QName("referenz")).getValue();
        Properties props = XmlHelper.parseSimpleElements(element.getName(), parser);
        this.bezeichner = new Bezeichner(props);
        this.bemerkung = props.getProperty("bemerkung", "");
        this.auspraegung = props.getProperty("auspraegung", "");
        LOG.debug("{} created.", (Object)this);
    }

    public String getId() {
        return this.id;
    }

    public Bezeichner getBezeichner() {
        return this.bezeichner;
    }

    public String getName() {
        return this.bezeichner.getName();
    }

    public String getTechnischerName() {
        return this.bezeichner.getTechnischerName();
    }

    public String getAuspraegung() {
        return this.auspraegung;
    }

    public String getBemerkung() {
        return this.bemerkung;
    }

    public List<String> getDefaultWerte() {
        ArrayList<String> defaultWerte = new ArrayList<String>();
        String[] lines = this.bemerkung.trim().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String[] values = lines[i].split("=");
            if (values.length != 2) continue;
            defaultWerte.add(values[0].trim());
        }
        return defaultWerte;
    }

    public boolean hasAuspraegung() {
        return StringUtils.isNotEmpty(this.auspraegung);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " \"" + this.id + "\" (" + this.bezeichner + ")";
    }
}

