/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import de.jfachwert.Text;
import gdv.xport.feld.Align;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datentyp;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.satz.xml.FeldReferenz;
import gdv.xport.satz.xml.TeildatensatzXml;
import gdv.xport.util.XmlHelper;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FeldXml
extends Feld {
    private static final Logger LOG = LogManager.getLogger(FeldXml.class);
    private final String id;
    private final Datentyp datentyp;
    private final int nachkommastellen;

    public FeldXml(XMLEventReader parser) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement(parser));
    }

    public FeldXml(XMLEventReader parser, StartElement element) throws XMLStreamException {
        this(FeldXml.parse(parser, element));
    }

    private FeldXml(Properties props) {
        super(new Bezeichner(props), 1, FeldXml.toInhalt(props), Align.LEFT);
        this.id = props.getProperty("ID");
        this.datentyp = Datentyp.asValue(props.getProperty("datentyp"));
        this.nachkommastellen = Integer.parseInt(props.getProperty("nachkommastellen", "0"));
        LOG.debug("{} created.", (Object)this);
    }

    private static String toInhalt(Properties props) {
        int l = Integer.parseInt(props.getProperty("bytes", "1"));
        String s = props.getProperty("auspraegung", " ");
        return StringUtils.rightPad(s, l);
    }

    private static Properties parse(XMLEventReader parser, StartElement element) throws XMLStreamException {
        String xid = element.getAttributeByName(new QName("referenz")).getValue();
        LOG.trace("Parsing <feld referenz=\"{}\"...", (Object)xid);
        Properties props = XmlHelper.parseSimpleElements(element.getName(), parser);
        props.put("ID", xid);
        return props;
    }

    public String getId() {
        return this.id;
    }

    public Datentyp getDatentyp() {
        return this.datentyp;
    }

    public int getNachkommastellen() {
        return this.nachkommastellen;
    }

    public Feld toFeld(int byteAddress) {
        return this.toFeld(byteAddress, this.getBezeichner(), "");
    }

    @Deprecated
    public Feld toFeld(int byteAddress, Bezeichner neuerBezeichner) {
        return this.toFeld(byteAddress, neuerBezeichner, "");
    }

    public Feld toFeld(int byteAddress, FeldReferenz referenz) {
        return this.toFeld(byteAddress, referenz.getBezeichner(), referenz.getBemerkung());
    }

    public Feld toFeld(int byteAddress, FeldReferenz referenz, TeildatensatzXml tdXml) {
        Feld feld;
        Bezeichner bezeichner = referenz.getBezeichner();
        if (!(tdXml.getGdvSatzartName().equals("0001") && byteAddress >= 96 || tdXml.getGdvSatzartName().equals("0220.030") && tdXml.getSatznummer().toChar() == '9' && byteAddress == 43)) {
            bezeichner = new Bezeichner(referenz.getBezeichner().getName());
        }
        if (!(feld = this.toFeld(byteAddress, bezeichner, referenz.getBemerkung())).getBezeichner().getTechnischerName().equalsIgnoreCase("Satzart")) {
            int inc = 0;
            while (tdXml.hasFeld(feld)) {
                Bezeichner bezeichnerNeu = new Bezeichner(bezeichner.getName(), bezeichner.getTechnischerName() + ++inc);
                feld = this.toFeld(byteAddress, bezeichnerNeu, referenz.getBemerkung());
            }
        }
        return feld;
    }

    private Feld toFeld(int byteAddress, Bezeichner neuerBezeichner, String bemerkung) {
        Feld f = this.datentyp.asFeld(neuerBezeichner, this.getAnzahlBytes(), byteAddress);
        switch (this.datentyp) {
            case NUMERISCH: 
            case FLIESSKOMMA: {
                f = new NumFeld(neuerBezeichner, this.getAnzahlBytes(), byteAddress).mitNachkommastellen(this.nachkommastellen);
                if (!bemerkung.contains("MMJJJJ")) break;
                f = new Datum(neuerBezeichner, this.getAnzahlBytes(), byteAddress);
                break;
            }
            case ALPHANUMERISCH: {
                if (!Text.replaceUmlaute(bemerkung).toLowerCase().contains("rechtsbuendig")) break;
                f = new AlphaNumFeld(neuerBezeichner, this.getAnzahlBytes(), byteAddress, Align.RIGHT);
            }
        }
        if (this.hasValue()) {
            f.setInhalt(this.getInhalt());
        }
        return f;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " \"" + this.id + "\" (" + this.getBezeichner() + ")";
    }
}

