/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gdv.xport.config.Config;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.xml.FeldReferenz;
import gdv.xport.satz.xml.FeldXml;
import gdv.xport.satz.xml.Satzende;
import gdv.xport.satz.xml.TeildatensatzXml;
import gdv.xport.satz.xml.XmlService;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.XmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SatzXml
extends Datensatz {
    private static final Logger LOG = LogManager.getLogger(SatzXml.class);

    public SatzXml(XMLEventReader parser) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement("satzart", parser), Config.getInstance());
    }

    public SatzXml(XMLEventReader parser, StartElement element, Config config) throws XMLStreamException {
        super(SatzTyp.of(0), config);
        this.parse(element, parser);
    }

    public SatzXml(Datensatz orig) {
        super(orig);
    }

    @Override
    protected void setUpTeildatensaetze() {
        this.removeAllTeildatensaetze();
    }

    private void parse(StartElement element, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                this.parseElement(event.asStartElement(), reader);
            } else if (XmlHelper.isEndElement(event, element.getName())) {
                LOG.debug("{}...{} successful parsed.", (Object)element, (Object)event);
                return;
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseElement(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Parsing element {}.", (Object)element);
        QName name = element.getName();
        if ("satzanfang".equals(name.getLocalPart())) {
            this.parseTeildatensatz(element, reader);
        } else if ("feldreferenz".equals(name.getLocalPart())) {
            this.parseFeldreferenz(element, reader);
        } else if ("version".equals(name.getLocalPart())) {
            this.parseSatzversion(element, reader);
        }
    }

    private void parseTeildatensatz(StartElement element, XMLEventReader reader) throws XMLStreamException {
        TeildatensatzXml tds = this.parseSatzanfang(element, reader);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "feldreferenz")) {
                tds.add(new FeldReferenz(reader, event.asStartElement()));
                continue;
            }
            if (!XmlHelper.isStartElement(event, "satzende")) continue;
            LOG.trace("<{}> is reached.", (Object)element);
            tds.setSatzende(new Satzende(reader, event.asStartElement()));
            this.add(tds);
            return;
        }
        throw new XMLStreamException("<satzende> for " + element + " not found");
    }

    private TeildatensatzXml parseSatzanfang(StartElement element, XMLEventReader reader) throws XMLStreamException {
        Attribute teilsatz = element.getAttributeByName(new QName("teilsatz"));
        int nr = Integer.parseInt(teilsatz.getValue());
        TeildatensatzXml tds = new TeildatensatzXml(this, nr);
        LOG.debug("Teildatensatz {} added to {}.", (Object)nr, (Object)this);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "feldreferenz")) {
                tds.add(new FeldReferenz(reader, event.asStartElement()));
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.trace("End of <{}> is reached.", (Object)element);
            return tds;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseFeldreferenz(StartElement element, XMLEventReader reader) throws XMLStreamException {
        FeldReferenz referenz = new FeldReferenz(reader, element);
        if (referenz.hasAuspraegung()) {
            if ("Satzart".equals(referenz.getName())) {
                this.getSatzartFeld().setInhalt(referenz.getAuspraegung());
                this.setGdvSatzartName(referenz.getAuspraegung());
            } else if ("Sparte".equals(referenz.getName())) {
                this.setSparte(referenz.getAuspraegung());
                this.setGdvSatzartName(referenz.getAuspraegung());
                LOG.debug("Sparte: " + referenz.getAuspraegung());
            } else if ("Satznummer".equals(referenz.getName())) {
                this.setGdvSatzartNummer(referenz.getAuspraegung());
                this.setGdvSatzartName(referenz.getAuspraegung());
                LOG.debug("Satznummer: " + referenz.getAuspraegung());
            }
        }
    }

    private void parseSatzversion(StartElement element, XMLEventReader reader) throws XMLStreamException {
        XMLEvent event;
        if (reader.hasNext() && (event = reader.nextEvent()).isCharacters()) {
            this.getSatzversion().setInhalt(event.asCharacters().getData());
        }
    }

    public void setFelder(Map<String, FeldXml> felder) {
        LOG.trace("Setting missing felder infos to {}.", (Object)this);
        for (int n = 1; n <= this.getNumberOfTeildatensaetze(); ++n) {
            TeildatensatzXml tdsXml = (TeildatensatzXml)this.getTeildatensatz(n);
            tdsXml.updateWith(felder);
        }
    }

    @JsonIgnore
    public List<SatzTyp> getSupportedSatzTypen() {
        ArrayList<SatzTyp> satzTypen = new ArrayList<SatzTyp>();
        satzTypen.add(SatzTyp.of(this.getGdvSatzartName()));
        return satzTypen;
    }

    public static SatzXml of(File file) throws IOException, XMLStreamException {
        try (FileInputStream istream = new FileInputStream(file);){
            SatzXml satzXml = SatzXml.createSatzXml(istream);
            return satzXml;
        }
    }

    public static SatzXml of(String resource) throws IOException, XMLStreamException {
        try (InputStream istream = SatzXml.class.getResourceAsStream(resource);){
            if (istream == null) {
                throw new IllegalArgumentException("not a resource: " + resource);
            }
            SatzXml satzXml = SatzXml.createSatzXml(istream);
            return satzXml;
        }
    }

    public static SatzXml of(URI resource) throws IOException, XMLStreamException {
        String scheme = resource.getScheme();
        switch (scheme.toLowerCase()) {
            case "classpath": {
                return SatzXml.of(resource.getPath());
            }
            case "file": {
                return SatzXml.of(new File(resource));
            }
        }
        throw new UnsupportedOperationException("Protokoll '" + scheme + "' wird (noch) nicht unterstuetzt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SatzXml createSatzXml(InputStream istream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try (XMLEventReader parser = xmlInputFactory.createXMLEventReader(istream);){
            SatzXml satz = new SatzXml(parser);
            Map<String, FeldXml> xmlFelder = XmlService.parseFelder(parser);
            satz.setFelder(xmlFelder);
            SatzXml satzXml = satz;
            return satzXml;
        }
    }
}

