/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.xml.FeldReferenz;
import gdv.xport.satz.xml.FeldXml;
import gdv.xport.satz.xml.SatzXml;
import gdv.xport.satz.xml.Satzende;
import gdv.xport.util.SatzTyp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TeildatensatzXml
extends Teildatensatz {
    private static final Logger LOG = LogManager.getLogger(TeildatensatzXml.class);
    private final List<FeldReferenz> feldReferenzen = new ArrayList<FeldReferenz>();
    private Satzende satzende;

    public TeildatensatzXml(int satzart, int nr) {
        super(SatzTyp.of(satzart), nr);
    }

    public TeildatensatzXml(SatzXml satz, int nr) {
        super((Satz)satz, nr);
    }

    public void add(FeldReferenz referenz) {
        this.feldReferenzen.add(referenz);
    }

    public void setSatzende(Satzende satzende) {
        this.satzende = satzende;
    }

    public void updateWith(Map<String, FeldXml> felder) {
        int byteAddress = 1;
        for (FeldReferenz referenz : this.feldReferenzen) {
            FeldXml feldXml = this.getFeld(felder, referenz.getId());
            feldXml.setInhalt(referenz.getAuspraegung());
            this.addFeld(feldXml, byteAddress, referenz);
            byteAddress += feldXml.getAnzahlBytes();
        }
        this.updateSatzendeWith(byteAddress, felder);
        LOG.trace("{} felder set.", (Object)this.feldReferenzen.size());
    }

    private FeldXml getFeld(Map<String, FeldXml> felder, String id) {
        FeldXml feldXml = felder.get(id);
        if (feldXml == null) {
            throw new IllegalArgumentException("reference '" + id + "' not found in " + felder);
        }
        return feldXml;
    }

    private void updateSatzendeWith(int startAddress, Map<String, FeldXml> felder) {
        ArrayList<Feld> endeDatenfelder = new ArrayList<Feld>();
        List<FeldReferenz> referenzen = this.satzende.getFeldReferenzen();
        int endAddress = 256;
        for (int i = referenzen.size() - 1; i >= 0; --i) {
            FeldReferenz referenz = referenzen.get(i);
            FeldXml feldXml = felder.get(referenz.getId());
            Feld feld = feldXml.toFeld((endAddress -= feldXml.getAnzahlBytes()) + 1, referenz).mitConfig(this.getConfig());
            endeDatenfelder.add(feld);
        }
        int length = endAddress + 1 - startAddress;
        if (length > 0) {
            AlphaNumFeld leerstelle = new AlphaNumFeld(Bezeichner.LEERSTELLEN, endAddress + 1 - startAddress, startAddress);
            endeDatenfelder.add(leerstelle);
        }
        Collections.sort(endeDatenfelder);
        for (Feld feld : endeDatenfelder) {
            this.add(feld);
        }
    }

    private void addFeld(FeldXml feldXml, int byteAddress, FeldReferenz referenz) {
        Feld feld = feldXml.toFeld(byteAddress, referenz).mitConfig(this.getConfig());
        if (!this.hasFeld(feld)) {
            super.add(feld);
        } else {
            LOG.trace("{} not added again.", (Object)feld);
        }
    }

    public FeldReferenz getFeldRefenz(Bezeichner bezeichner) {
        for (FeldReferenz ref : this.feldReferenzen) {
            if (!bezeichner.equals(ref.getBezeichner())) continue;
            return ref;
        }
        throw new IllegalArgumentException(bezeichner + " not part of " + this);
    }
}

