/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.xml;

import gdv.xport.config.Config;
import gdv.xport.satz.xml.FeldXml;
import gdv.xport.satz.xml.SatzXml;
import gdv.xport.util.NotRegisteredException;
import gdv.xport.util.NotUniqueException;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlService {
    private static final Logger LOG = LogManager.getLogger(XmlService.class);
    private static final Map<Config, XmlService> INSTANCES = new HashMap<Config, XmlService>();
    private final Config config;
    private final List<SatzXml> saetze = new ArrayList<SatzXml>();
    private final Map<SatzTyp, SatzXml> satzarten = new HashMap<SatzTyp, SatzXml>();
    private final Map<String, FeldXml> felder = new HashMap<String, FeldXml>();
    private String gdvRelease = "";

    public static XmlService getInstance() {
        String xmlResource = Config.getXmlResource();
        try {
            return XmlService.getInstance(xmlResource);
        }
        catch (IOException | XMLStreamException ex) {
            LOG.error("Cannot parse XML from resource '{}':", (Object)xmlResource, (Object)ex);
            return new XmlService();
        }
    }

    public static XmlService getInstance(Config cfg) throws XMLStreamException, IOException {
        XmlService service = INSTANCES.get(cfg);
        if (service == null) {
            service = XmlService.createXmlService(cfg);
            INSTANCES.put(cfg, service);
            LOG.info("{} wurde mit Resource {} angelegt.", (Object)service, (Object)cfg);
        }
        return service;
    }

    public static XmlService getInstance(String resource) throws XMLStreamException, IOException {
        return XmlService.getInstance(Config.getInstance().withProperty("gdv.XML-Resource", resource));
    }

    public static XmlService getInstance(URI resource) throws XMLStreamException, IOException {
        Config cfg = Config.getInstance().withProperty("gdv.XML-Resource", resource.toString());
        XmlService service = INSTANCES.get(cfg);
        if (service == null) {
            service = XmlService.createXmlService(resource, cfg);
            INSTANCES.put(cfg, service);
            LOG.info("{} wurde mit Resource {} angelegt.", (Object)service, (Object)resource);
        }
        return service;
    }

    private static XmlService createXmlService(URI resource, Config cfg) throws XMLStreamException, IOException {
        try (InputStream istream = resource.toURL().openStream();){
            XmlService xmlService = XmlService.createXmlService(istream, cfg);
            return xmlService;
        }
    }

    private static XmlService createXmlService(Config cfg) throws XMLStreamException, IOException {
        String resource = cfg.getProperty("gdv.XML-Resource", "VUVM2018.xml");
        try (InputStream istream = XmlService.class.getResourceAsStream(resource);){
            if (istream == null) {
                throw new XMLStreamException("resource '" + resource + "' not found");
            }
            XmlService xmlService = XmlService.createXmlService(istream, cfg);
            return xmlService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlService createXmlService(InputStream istream, Config cfg) throws XMLStreamException {
        try (XMLEventReader parser = XmlService.createXMLEventReader(istream);){
            XmlService xmlService = new XmlService(parser, cfg);
            return xmlService;
        }
    }

    private static XMLEventReader createXMLEventReader(InputStream istream) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return factory.createXMLEventReader(istream);
    }

    private XmlService() {
        LOG.debug("Default XmlService created.");
        this.config = Config.EMPTY;
    }

    public XmlService(XMLEventReader parser) throws XMLStreamException {
        this(parser, Config.getInstance());
    }

    private XmlService(XMLEventReader parser, Config config) throws XMLStreamException {
        this(parser, XmlHelper.getNextStartElement(parser), config);
    }

    public XmlService(XMLEventReader parser, StartElement startElement) throws XMLStreamException {
        this(parser, startElement, Config.getInstance());
    }

    public XmlService(XMLEventReader parser, StartElement startElement, Config config) throws XMLStreamException {
        this.config = config;
        this.parse(startElement, parser);
    }

    private void parse(StartElement element, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                this.parseElement(event.asStartElement(), reader);
            } else if (XmlHelper.isEndElement(event, element.getName())) {
                LOG.info("{} Satzarten successful parsed from {}...{}.", (Object)this.saetze.size(), (Object)element, (Object)event);
                return;
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseElement(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Parsing element {}.", (Object)element);
        QName name = element.getName();
        if ("info".equals(name.getLocalPart())) {
            this.parseInfo(element, reader);
        } else if ("satzarten".equals(name.getLocalPart())) {
            this.parseSatzarten(element, reader);
        } else if ("felder".equals(name.getLocalPart())) {
            this.felder.putAll(XmlService.parseFelder(element, reader));
            this.setFelder(this.felder);
        } else {
            XmlHelper.ignore(name, reader);
        }
    }

    private void parseSatzarten(StartElement element, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "satzart")) {
                SatzXml satz = new SatzXml(reader, event.asStartElement(), this.config);
                this.saetze.add(satz);
                LOG.debug("Satz {} added .", (Object)satz);
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.debug("{} satzarten successful parsed.", (Object)this.satzarten.size());
            return;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    private void parseInfo(StartElement element, XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "stand")) {
                if (reader.hasNext() && (event = reader.nextEvent()).isCharacters()) {
                    this.gdvRelease = event.asCharacters().getData();
                    LOG.info(this.gdvRelease);
                }
                LOG.debug("GdvRelease '{}' found.", (Object)this.gdvRelease);
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.debug("GdvRelease {} successful parsed. ", (Object)this.gdvRelease);
            return;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    public static Map<String, FeldXml> parseFelder(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlHelper.isStartElement(event, "felder")) {
                return XmlService.parseFelder(event.asStartElement(), reader);
            }
            LOG.trace("Event {} is ignored.", (Object)event);
        }
        throw new XMLStreamException("<felder>...</felder> not found");
    }

    private static Map<String, FeldXml> parseFelder(StartElement element, XMLEventReader reader) throws XMLStreamException {
        LOG.trace("Element {} will be parsed.", (Object)element);
        HashMap<String, FeldXml> felder = new HashMap<String, FeldXml>();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                FeldXml feld = new FeldXml(reader, event.asStartElement());
                felder.put(feld.getId(), feld);
                continue;
            }
            if (!XmlHelper.isEndElement(event, element.getName())) continue;
            LOG.debug("{} felder between {}...{} successful parsed.", (Object)felder.size(), (Object)element, (Object)event);
            return felder;
        }
        throw new XMLStreamException("end of " + element + " not found");
    }

    public Map<String, FeldXml> getFelder() {
        return this.felder;
    }

    private void setFelder(Map<String, FeldXml> felder) {
        LOG.debug("Missing felder for {} saetze will be set.", (Object)this.satzarten.size());
        for (SatzXml satz : this.saetze) {
            satz.setFelder(felder);
            this.registerSatzart(satz);
        }
    }

    private void registerSatzart(SatzXml satz) {
        List<SatzTyp> supportedSatzTypen = satz.getSupportedSatzTypen();
        if (supportedSatzTypen.isEmpty()) {
            this.registerSatzart(SatzTyp.of(satz.getGdvSatzartName()), satz);
        } else {
            for (SatzTyp type : supportedSatzTypen) {
                this.registerSatzart(type, satz);
                LOG.trace("Satz {} registered as {}.", (Object)satz, (Object)type);
            }
        }
    }

    private void registerSatzart(SatzTyp type, SatzXml satz) {
        satz.init(type);
        this.satzarten.put(type, satz);
    }

    @Deprecated
    public SatzXml getSatzart(int satzart) {
        SatzXml satz = this.satzarten.get(SatzTyp.of(Integer.toString(satzart)));
        if (satz != null) {
            return new SatzXml(satz);
        }
        ArrayList<SatzTyp> satzTypen = new ArrayList<SatzTyp>();
        for (SatzTyp satzNr : this.satzarten.keySet()) {
            if (satzNr.getSatzart() != satzart) continue;
            satzTypen.add(satzNr);
        }
        if (satzTypen.isEmpty()) {
            throw new NotRegisteredException(satzart);
        }
        if (satzTypen.size() > 1) {
            XmlService.checkSatzarten(satzTypen);
        }
        return new SatzXml(this.satzarten.get(satzTypen.get(0)));
    }

    private static void checkSatzarten(List<SatzTyp> satzTypen) {
        SatzTyp first = satzTypen.get(0);
        for (int i = 1; i < satzTypen.size(); ++i) {
            if (first.getSparte() == satzTypen.get(i).getSparte()) continue;
            throw new NotUniqueException("Sparte for Satzart " + first.getSatzart() + " is missing: " + satzTypen);
        }
    }

    public SatzXml getSatzart(SatzTyp satzNr) {
        SatzXml satz = this.satzarten.get(satzNr);
        if (satz == null) {
            throw new NotRegisteredException(satzNr);
        }
        return new SatzXml(satz);
    }

    public Map<SatzTyp, SatzXml> getSatzarten() {
        HashMap<SatzTyp, SatzXml> copy = new HashMap<SatzTyp, SatzXml>();
        for (Map.Entry<SatzTyp, SatzXml> entry : this.satzarten.entrySet()) {
            copy.put(entry.getKey(), new SatzXml(entry.getValue()));
        }
        return copy;
    }

    public String getSatzVersion(SatzTyp satzTyp) {
        SatzXml satzXml = this.satzarten.get(satzTyp);
        if (satzXml == null) {
            throw new IllegalArgumentException("nicht registriert: " + satzTyp);
        }
        return satzXml.getSatzversion().getInhalt();
    }

    public String getGdvRelease() {
        return this.gdvRelease;
    }

    public Config getConfig() {
        return this.config;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (Stand " + this.getGdvRelease() + ")";
    }
}

