/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.config.Config;
import gdv.xport.event.ImportListener;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Satz;
import gdv.xport.util.FormatterException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class AbstractFormatter
implements ImportListener,
AutoCloseable {
    private final Config config;
    private Writer writer;

    public AbstractFormatter() {
        this(System.out);
    }

    public AbstractFormatter(Writer writer) {
        this(writer, Config.getInstance());
    }

    protected AbstractFormatter(Writer writer, Config config) {
        this.writer = writer;
        this.config = config;
    }

    public AbstractFormatter(OutputStream ostream) {
        this(new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING));
    }

    protected final Config getConfig() {
        return this.config;
    }

    public final Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream ostream) {
        OutputStreamWriter ostreamWriter = new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING);
        this.setWriter(ostreamWriter);
    }

    @Override
    public void notice(Satz satz) {
        try {
            this.write(satz);
        }
        catch (IOException ioe) {
            throw new FormatterException("cannot format " + satz, ioe);
        }
    }

    public void write(Satz satz) throws IOException {
        throw new UnsupportedOperationException("write of " + satz + " not yet supported by " + this.getClass());
    }

    public void write(Datenpaket datenpaket) throws IOException {
        this.write(datenpaket.getVorsatz());
        for (Datensatz satz : datenpaket.getDatensaetze()) {
            this.write(satz);
        }
        this.write(datenpaket.getNachsatz());
        this.writer.flush();
    }

    public void write(String content) throws IOException {
        this.writer.write(content);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

