/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Satz;
import gdv.xport.util.AbstractFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public final class CsvFormatter
extends AbstractFormatter {
    private final Map<Bezeichner, Feld> felder = new LinkedHashMap<Bezeichner, Feld>();

    public CsvFormatter() {
    }

    public CsvFormatter(Writer writer) {
        super(writer);
    }

    public CsvFormatter(OutputStream ostream) {
        super(ostream);
    }

    @Override
    public void write(Datenpaket datenpaket) throws IOException {
        this.buildHead(datenpaket);
        this.writeHead();
        this.writeBody(datenpaket);
    }

    @Override
    public void write(Satz satz) throws IOException {
        this.buildHead(satz);
        this.writeHead();
        this.writeBody(satz);
    }

    private void buildHead(Datenpaket datenpaket) {
        this.buildHead(datenpaket.getVorsatz());
        for (Datensatz satz : datenpaket.getDatensaetze()) {
            this.buildHead(satz);
        }
        this.buildHead(datenpaket.getNachsatz());
    }

    private void buildHead(Satz satz) {
        for (Feld feld : satz.getFelder()) {
            if (this.felder.containsKey(feld.getBezeichner())) continue;
            this.felder.put(feld.getBezeichner(), feld);
        }
    }

    private void writeHead() throws IOException {
        for (Bezeichner bezeichner : this.felder.keySet()) {
            this.write(bezeichner.getName());
            this.write(";");
        }
        this.write("\n");
    }

    private void writeBody(Datenpaket datenpaket) throws IOException {
        this.writeBody(datenpaket.getVorsatz());
        for (Datensatz satz : datenpaket.getDatensaetze()) {
            this.writeBody(satz);
        }
        this.writeBody(datenpaket.getNachsatz());
    }

    private void writeBody(Satz satz) throws IOException {
        this.resetFelder();
        for (Feld feld : satz.getFelder()) {
            this.felder.put(feld.getBezeichner(), feld);
        }
        for (Feld feld : this.felder.values()) {
            this.write(StringEscapeUtils.escapeCsv(feld.getInhalt().trim()));
            this.write(";");
        }
        this.write("\n");
        this.getWriter().flush();
    }

    private void resetFelder() {
        for (Map.Entry<Bezeichner, Feld> entry : this.felder.entrySet()) {
            entry.setValue(Feld.NULL_FELD);
        }
    }
}

