/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.config.Config;
import gdv.xport.config.ConfigException;
import gdv.xport.feld.Align;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datentyp;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.util.AbstractFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GdvXmlFormatter
extends AbstractFormatter {
    private static final Logger LOG = LogManager.getLogger(GdvXmlFormatter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String DEFAULT_INFO = "(c)reated by gdv-xport at " + LocalDate.now();
    private XMLStreamWriter xmlStreamWriter;
    private final Map<String, Feld> felder = new HashMap<String, Feld>();
    private final String stand;

    public GdvXmlFormatter() {
        this(System.out);
    }

    public GdvXmlFormatter(Writer writer) {
        this(writer, DEFAULT_INFO);
    }

    public GdvXmlFormatter(Writer writer, String stand) {
        super(writer);
        this.stand = stand;
        this.xmlStreamWriter = GdvXmlFormatter.createXMLStreamWriter(writer, this.stand);
    }

    public GdvXmlFormatter(OutputStream ostream, String stand) {
        this(ostream, Config.getInstance().withProperty("gdv.export.xml.stand", stand));
    }

    public GdvXmlFormatter(OutputStream ostream) {
        this(ostream, DEFAULT_INFO);
    }

    public GdvXmlFormatter(OutputStream ostream, Config config) {
        super(new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING), config);
        this.stand = config.getProperty("gdv.export.xml.stand", DEFAULT_INFO);
        this.xmlStreamWriter = GdvXmlFormatter.createXMLStreamWriter(ostream, this.stand);
    }

    private static XMLStreamWriter writeHead(XMLStreamWriter writer, String gueltigAbDatum) throws XMLStreamException {
        IndentingXMLStreamWriter indentingWriter = GdvXmlFormatter.toIndentingStreamWriter(writer);
        indentingWriter.writeStartDocument(StandardCharsets.ISO_8859_1.toString(), "1.0");
        indentingWriter.writeStartElement("service");
        GdvXmlFormatter.writeInfo(gueltigAbDatum, indentingWriter);
        indentingWriter.writeStartElement("satzarten");
        return indentingWriter;
    }

    private static void writeInfo(String gueltigAbDatum, XMLStreamWriter indentingWriter) throws XMLStreamException {
        indentingWriter.writeStartElement("info");
        indentingWriter.writeStartElement("stand");
        indentingWriter.writeCharacters(gueltigAbDatum);
        indentingWriter.writeEndElement();
        indentingWriter.writeEndElement();
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.xmlStreamWriter = GdvXmlFormatter.createXMLStreamWriter(writer, this.stand);
    }

    @Override
    public void setWriter(OutputStream ostream) {
        super.setWriter(ostream);
        this.xmlStreamWriter = GdvXmlFormatter.createXMLStreamWriter(ostream, this.stand);
    }

    @Override
    public void close() throws IOException {
        try {
            this.xmlStreamWriter.writeEndElement();
            this.writeFelder();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
            this.xmlStreamWriter.flush();
            this.xmlStreamWriter.close();
        }
        catch (XMLStreamException ex) {
            throw new IOException("cannot close " + this.xmlStreamWriter, ex);
        }
        finally {
            super.close();
        }
    }

    @Override
    public void write(Satz satz) throws IOException {
        try {
            this.writeComment(satz.toShortString());
            this.xmlStreamWriter.writeStartElement("satzart");
            this.writeKennzeichnung(satz);
            this.writeElement("version", satz.getSatzversion().getInhalt());
            this.write(satz.getTeildatensaetze());
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IOException("cannot format " + satz, ex);
        }
    }

    private void writeKennzeichnung(Satz satz) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("kennzeichnung");
        this.writeReferenz(satz.getSatzartFeld());
        this.writeSparte(satz);
        this.writeSatznummer(satz);
        this.xmlStreamWriter.writeEndElement();
    }

    private void write(List<Teildatensatz> teildatensaetze) throws XMLStreamException {
        for (Teildatensatz tds : teildatensaetze) {
            this.writeComment(tds.toShortString());
            this.xmlStreamWriter.writeEmptyElement("satzanfang");
            this.xmlStreamWriter.writeAttribute("teilsatz", tds.getSatznummer().getInhalt());
            for (Feld feld : this.getFelderOhneLuecken(tds)) {
                this.writeComment(feld.toShortString());
                this.writeReferenz(feld);
                this.felder.putIfAbsent(this.toFeldReferenzId(feld), feld);
            }
            this.xmlStreamWriter.writeEmptyElement("satzende");
            this.xmlStreamWriter.flush();
        }
    }

    private List<Feld> getFelderOhneLuecken(Teildatensatz tds) {
        ArrayList<Feld> felder = new ArrayList<Feld>();
        int adresse = 1;
        for (Feld feld : tds.getFelder()) {
            if (adresse < feld.getByteAdresse()) {
                felder.add(new AlphaNumFeld(Bezeichner.of("Leerstellen"), feld.getByteAdresse() - adresse, adresse));
                LOG.info("An Adresse {} wurde {} mit Leerstellen aufgefuellt.", (Object)adresse, (Object)tds.toShortString());
            }
            felder.add(feld);
            adresse = feld.getEndAdresse() + 1;
        }
        return felder;
    }

    private void writeReferenz(Feld feld) throws XMLStreamException {
        Bezeichner bezeichner = feld.getBezeichner();
        this.xmlStreamWriter.writeStartElement("feldreferenz");
        this.xmlStreamWriter.writeAttribute("referenz", this.toFeldReferenzId(feld));
        this.writeElement("name", bezeichner.getName());
        this.writeElement("technischerName", bezeichner.getTechnischerName());
        if (feld.hasValue()) {
            this.writeElement("auspraegung", feld.getInhalt().trim());
        }
        if (feld instanceof AlphaNumFeld) {
            this.writeAlignment((AlphaNumFeld)feld);
        } else if (feld instanceof Datum) {
            this.writeElement("bemerkung", ((Datum)feld).getFormat());
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeAlignment(AlphaNumFeld feld) throws XMLStreamException {
        if (feld.getAusrichtung() == Align.RIGHT) {
            this.writeElement("bemerkung", "rechtsbuendig");
        }
    }

    private String toFeldReferenzId(Feld feld) {
        return String.format("%03d-%03d-%s-%s", feld.getByteAdresse(), feld.getEndAdresse(), feld.getBezeichner().getTechnischerName(), Datentyp.asString(feld));
    }

    private void writeSparte(Satz satz) throws XMLStreamException {
        if (satz.getSatzTyp().hasSparteInGdvSatzartName()) {
            Feld sparteFeld = new Feld(Bezeichner.SPARTE, 11, satz.getSatzTyp().getSparteMitArt(), Align.LEFT);
            this.writeReferenz(sparteFeld);
        }
    }

    private void writeSatznummer(Satz satz) throws XMLStreamException {
        Feld satznummer = new Feld(Bezeichner.SATZNUMMER, 256, satz.getGdvSatzartNummer(), Align.LEFT);
        this.writeReferenz(satznummer);
    }

    private void writeFelder() throws XMLStreamException {
        TreeMap<String, Feld> sorted2 = new TreeMap<String, Feld>(this.felder);
        Set<Map.Entry<String, Feld>> mappings = sorted2.entrySet();
        this.xmlStreamWriter.writeStartElement("felder");
        for (Map.Entry<String, Feld> entry : mappings) {
            this.write(entry.getValue());
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void write(Feld feld) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("feld");
        this.xmlStreamWriter.writeAttribute("referenz", this.toFeldReferenzId(feld));
        this.writeElement("name", feld.getBezeichner().getName());
        this.writeElement("bytes", Integer.toString(feld.getAnzahlBytes()));
        this.writeElement("datentyp", Datentyp.asString(feld));
        if (feld instanceof NumFeld) {
            this.writeNachkommastellen((NumFeld)feld);
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeNachkommastellen(NumFeld feld) throws XMLStreamException {
        if (feld.getNachkommastellen() > 0) {
            this.writeElement("nachkommastellen", Integer.toString(feld.getNachkommastellen()));
        }
    }

    private void writeElement(String tag, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(tag);
        this.xmlStreamWriter.writeCharacters(value);
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeComment(String comment) throws XMLStreamException {
        this.xmlStreamWriter.writeComment(" " + comment.trim() + " ");
    }

    private static XMLStreamWriter createXMLStreamWriter(OutputStream textWriter, String gdvSatzVersion) {
        try {
            XMLStreamWriter out = XML_OUTPUT_FACTORY.createXMLStreamWriter(textWriter, Config.DEFAULT_ENCODING.name());
            return GdvXmlFormatter.writeHead(out, gdvSatzVersion);
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException("can't create XmlStreamWriter with " + textWriter, ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new ConfigException("XML problems", ex);
        }
    }

    private static XMLStreamWriter createXMLStreamWriter(Writer textWriter, String gdvSatzVersion) {
        try {
            XMLStreamWriter out = XML_OUTPUT_FACTORY.createXMLStreamWriter(textWriter);
            return GdvXmlFormatter.writeHead(out, gdvSatzVersion);
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException("can't create XmlStreamWriter with " + textWriter, ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new ConfigException("XML problems", ex);
        }
    }

    private static IndentingXMLStreamWriter toIndentingStreamWriter(XMLStreamWriter out) {
        IndentingXMLStreamWriter indentWriter = new IndentingXMLStreamWriter(out);
        indentWriter.setIndent("\t");
        return indentWriter;
    }
}

