/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.config.Config;
import gdv.xport.feld.Feld;
import gdv.xport.feld.Undefiniert;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.util.AbstractFormatter;
import gdv.xport.util.ShitHappenedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;

public final class HtmlFormatter
extends AbstractFormatter {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String HEAD;
    private static final String TAIL;
    private final StringWriter detailsWriter = new StringWriter();
    private String title = "GDV-Datei";
    private int zeile = 1;

    private static String readTemplate(String name) throws IOException {
        try (InputStream istream = HtmlFormatter.class.getResourceAsStream(name);){
            String string = IOUtils.toString(istream, Config.DEFAULT_ENCODING);
            return string;
        }
    }

    public HtmlFormatter() {
        this(System.out);
    }

    public HtmlFormatter(OutputStream ostream) {
        this(new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING));
    }

    public HtmlFormatter(Writer writer) {
        super(writer);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void write(Satz satz) throws IOException {
        try {
            if (satz.getSatzart() == 1) {
                this.writeHead();
            }
            this.writeSatz(satz);
            HtmlFormatter.writeDetailsTo(this.detailsWriter, satz, this.zeile);
            this.zeile += satz.getTeildatensaetze().size();
            if (satz.getSatzart() == 9999) {
                this.writeTail();
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException("cannot format " + satz, ex);
        }
    }

    private void writeHead() throws IOException {
        String head = MessageFormat.format(HEAD, Config.DEFAULT_ENCODING.name(), this.title);
        this.write(head);
        this.getWriter().flush();
    }

    private void writeSatz(Satz satz) throws XMLStreamException, IOException {
        StringWriter buffer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(buffer);
        HtmlFormatter.writeTo(xmlStreamWriter, satz, this.zeile);
        xmlStreamWriter.close();
        buffer.close();
        this.write(buffer.toString());
    }

    private void writeTail() throws IOException, XMLStreamException {
        this.getWriter().flush();
        this.detailsWriter.close();
        String tail = MessageFormat.format(TAIL, this.detailsWriter.toString());
        this.write(tail);
        this.write("<!-- (c)reated by gdv-xport at " + new Date() + " -->\n");
        this.getWriter().flush();
    }

    private static void writeTo(XMLStreamWriter xmlStreamWriter, Satz satz, int zeile) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("div");
        xmlStreamWriter.writeAttribute("class", "Satz");
        if (satz instanceof Datensatz) {
            Datensatz datensatz = (Datensatz)satz;
            xmlStreamWriter.writeAttribute("title", "Satzart " + datensatz.getSatzartFeld().getInhalt() + "." + datensatz.getSparteFeld().getInhalt());
        } else {
            xmlStreamWriter.writeAttribute("title", "Satzart " + satz.getSatzartFeld().getInhalt());
        }
        int n = zeile;
        Iterator<Teildatensatz> iterator2 = satz.getTeildatensaetze().iterator();
        while (iterator2.hasNext()) {
            Teildatensatz teildatensatz = iterator2.next();
            HtmlFormatter.writeTo(xmlStreamWriter, teildatensatz, n);
            if (iterator2.hasNext()) {
                xmlStreamWriter.writeCharacters("\n");
            }
            ++n;
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.flush();
    }

    private static void writeDetailsTo(Writer writer, Satz satz, int zeile) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
        HtmlFormatter.writeDetailsTo(xmlStreamWriter, satz, zeile);
    }

    private static void writeDetailsTo(XMLStreamWriter xmlStreamWriter, Satz satz, int zeile) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("h3");
        xmlStreamWriter.writeCharacters("Satzart " + satz.getSatzTyp().getGdvSatzartName() + " (" + satz.getClass().getSimpleName() + ")");
        int n = zeile;
        for (Teildatensatz teildatensatz : satz.getTeildatensaetze()) {
            HtmlFormatter.writeDetailsTo(xmlStreamWriter, teildatensatz, n);
            ++n;
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.flush();
    }

    private static void writeTo(XMLStreamWriter xmlStreamWriter, Teildatensatz teildatensatz, int zeile) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("span");
        xmlStreamWriter.writeAttribute("class", "Teildatensatz");
        xmlStreamWriter.writeAttribute("title", "Nr. " + teildatensatz.getSatznummer().getInhalt());
        int endAdresse = 1;
        for (Feld feld : teildatensatz.getFelder()) {
            int gap = feld.getByteAdresse() - endAdresse;
            if (gap > 1) {
                Undefiniert undefiniert = new Undefiniert(gap - 1, endAdresse + 1);
                HtmlFormatter.writeTo(xmlStreamWriter, undefiniert, zeile);
            }
            HtmlFormatter.writeTo(xmlStreamWriter, feld, zeile);
            endAdresse = feld.getEndAdresse();
        }
        if (endAdresse < 256) {
            Undefiniert undefiniert = new Undefiniert(256 - endAdresse, endAdresse + 1);
            HtmlFormatter.writeTo(xmlStreamWriter, undefiniert, zeile);
        }
        xmlStreamWriter.writeEndElement();
    }

    private static void writeDetailsTo(XMLStreamWriter xmlStreamWriter, Teildatensatz teildatensatz, int zeile) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("h4");
        xmlStreamWriter.writeCharacters("Zeile " + zeile + ": Teildatensatz " + teildatensatz.getSatznummer().getInhalt());
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.writeStartElement("table");
        xmlStreamWriter.writeStartElement("thead");
        xmlStreamWriter.writeStartElement("tr");
        HtmlFormatter.writeTagTo(xmlStreamWriter, "th", "Nr");
        HtmlFormatter.writeTagTo(xmlStreamWriter, "th", "Byte");
        HtmlFormatter.writeTagTo(xmlStreamWriter, "th", "Bezeichner");
        HtmlFormatter.writeTagTo(xmlStreamWriter, "th", "Datentyp");
        HtmlFormatter.writeTagTo(xmlStreamWriter, "th", "Inhalt");
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.writeStartElement("tbody");
        int nr = 1;
        for (Feld feld : teildatensatz.getFelder()) {
            HtmlFormatter.writeDetailsTo(xmlStreamWriter, feld, zeile, nr);
            ++nr;
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
        xmlStreamWriter.flush();
    }

    private static void writeTagTo(XMLStreamWriter xmlStreamWriter, String tag, String content) throws XMLStreamException {
        xmlStreamWriter.writeStartElement(tag);
        xmlStreamWriter.writeCharacters(content);
        xmlStreamWriter.writeEndElement();
    }

    private static void writeTo(XMLStreamWriter xmlStreamWriter, Feld feld, int zeile) throws XMLStreamException {
        String feldType = feld.getClass().getSimpleName();
        xmlStreamWriter.writeStartElement("a");
        xmlStreamWriter.writeAttribute("class", feldType);
        xmlStreamWriter.writeAttribute("title", "Byte " + feld.getByteAdresse() + "-" + feld.getEndAdresse() + ": " + feld.getBezeichnung());
        xmlStreamWriter.writeAttribute("href", "#" + HtmlFormatter.getAnchorFor(zeile, feld));
        HtmlFormatter.writeInhaltTo(xmlStreamWriter, feld);
        xmlStreamWriter.writeEndElement();
    }

    private static void writeDetailsTo(XMLStreamWriter xmlStreamWriter, Feld feld, int zeile, int nr) throws XMLStreamException {
        String typ = feld.getClass().getSimpleName();
        xmlStreamWriter.writeStartElement("tr");
        xmlStreamWriter.writeAttribute("class", typ);
        HtmlFormatter.writeTagTo(xmlStreamWriter, "td", Integer.toString(nr));
        xmlStreamWriter.writeStartElement("td");
        xmlStreamWriter.writeStartElement("a");
        xmlStreamWriter.writeAttribute("name", HtmlFormatter.getAnchorFor(zeile, feld));
        xmlStreamWriter.writeEndElement();
        if (feld.getAnzahlBytes() == 1) {
            xmlStreamWriter.writeCharacters(Integer.toString(feld.getByteAdresse()));
        } else {
            xmlStreamWriter.writeCharacters(feld.getByteAdresse() + " - " + feld.getEndAdresse());
        }
        xmlStreamWriter.writeEndElement();
        HtmlFormatter.writeTagTo(xmlStreamWriter, "td", feld.getBezeichnung());
        HtmlFormatter.writeTagTo(xmlStreamWriter, "td", typ);
        xmlStreamWriter.writeStartElement("td");
        HtmlFormatter.writeInhaltTo(xmlStreamWriter, feld);
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.writeCharacters("\n");
    }

    private static void writeInhaltTo(XMLStreamWriter xmlStreamWriter, Feld feld) throws XMLStreamException {
        String inhalt = feld.getInhalt();
        xmlStreamWriter.writeCharacters(inhalt);
    }

    private static String getAnchorFor(int zeile, Feld feld) {
        return "z" + zeile + "b" + feld.getByteAdresse();
    }

    public static String toString(Datenpaket datenpaket) {
        StringWriter swriter = new StringWriter();
        HtmlFormatter formatter = new HtmlFormatter(swriter);
        try {
            formatter.write(datenpaket);
        }
        catch (IOException shouldnothappen) {
            throw new ShitHappenedException("can't convert " + datenpaket + " to String", shouldnothappen);
        }
        IOUtils.closeQuietly(swriter);
        return swriter.toString();
    }

    static {
        try {
            HEAD = HtmlFormatter.readTemplate("head.html");
            TAIL = HtmlFormatter.readTemplate("tail.html");
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
    }
}

