/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Nachsatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import gdv.xport.util.SatzRegistry;
import gdv.xport.util.SatzTyp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SatzFactory {
    private static final Logger LOG = LogManager.getLogger(SatzFactory.class);
    private static final SatzRegistry FACTORY = SatzRegistry.getInstance();

    private SatzFactory() {
    }

    @Deprecated
    public static void reset() {
        FACTORY.reset();
        LOG.debug("Satzfactory wurde zurueckgesetzt.");
    }

    public static void register(Class<? extends Satz> clazz, int satzart) {
        FACTORY.register(clazz, satzart, SatzRegistry.NO_VALIDATOR);
    }

    public static void unregister(SatzTyp typ) {
        FACTORY.unregister(typ);
    }

    public static void register(Class<? extends Datensatz> clazz, SatzTyp satzNr) {
        FACTORY.register(clazz, satzNr);
    }

    @Deprecated
    public static Satz getSatz(int satzart) {
        return SatzFactory.getSatz(SatzTyp.of(satzart));
    }

    public static Satz getSatz(SatzTyp satztyp) {
        return FACTORY.getSatz(satztyp);
    }

    public static Satz getSatz(String content) {
        return FACTORY.getSatz(content);
    }

    @Deprecated
    public static Datensatz getDatensatz(int satzart) {
        return (Datensatz)SatzFactory.getSatz(satzart);
    }

    @Deprecated
    public static Datensatz getDatensatz(SatzTyp satzNr) {
        return (Datensatz)FACTORY.getSatz(satzNr);
    }

    public static Datenpaket getAllSupportedSaetze() {
        return FACTORY.getAllSupportedSaetze();
    }

    public static Vorsatz getVorsatz() {
        return FACTORY.getVorsatz();
    }

    public static Nachsatz getNachsatz() {
        return FACTORY.getNachsatz();
    }

    public static String getGdvRelease() {
        return FACTORY.getGdvRelease();
    }
}

