/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.Datenpaket;
import gdv.xport.config.Config;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Nachsatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import gdv.xport.satz.xml.SatzXml;
import gdv.xport.satz.xml.XmlService;
import gdv.xport.util.NotRegisteredException;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.ShitHappenedException;
import gdv.xport.util.VersionHandler;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ValidationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.Range;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SatzRegistry
implements VersionHandler {
    private static final Logger LOG = LogManager.getLogger(SatzRegistry.class);
    public static final Validator VALIDATOR = new Validator();
    public static final Validator NO_VALIDATOR = new Validator(Range.between(0, 9999));
    private static final Map<Config, SatzRegistry> INSTANCES = new HashMap<Config, SatzRegistry>();
    private static final Map<Map.Entry<SatzTyp, String>, Satz> SATZTYP_VERSIONEN = new HashMap<Map.Entry<SatzTyp, String>, Satz>();
    private final Map<SatzTyp, Satz> registeredSaetze = new ConcurrentHashMap<SatzTyp, Satz>();
    private final XmlService xmlService;

    private SatzRegistry(XmlService xmlService) {
        this.xmlService = xmlService;
    }

    public static SatzRegistry getInstance() {
        return SatzRegistry.getInstance(Config.getInstance());
    }

    public static SatzRegistry getInstance(Config cfg) {
        SatzRegistry factory = INSTANCES.get(cfg);
        try {
            if (factory == null) {
                factory = new SatzRegistry(XmlService.getInstance(cfg));
                INSTANCES.put(cfg, factory);
                LOG.info("{} wurde angelegt.", (Object)factory);
            }
            return factory;
        }
        catch (IOException | XMLStreamException ex) {
            throw new IllegalArgumentException("invalid config: " + cfg, ex);
        }
    }

    public static SatzRegistry getInstance(String resource) {
        return SatzRegistry.getInstance(Config.EMPTY.withProperty("gdv.XML-Resource", resource));
    }

    public static Satz getSatz(SatzTyp satzTyp, String version) {
        AbstractMap.SimpleEntry<SatzTyp, String> satzTypVersion = new AbstractMap.SimpleEntry<SatzTyp, String>(satzTyp, version);
        Satz satz = SATZTYP_VERSIONEN.get(satzTypVersion);
        if (satz == null) {
            satz = SatzRegistry.getSatz(satzTypVersion);
            SATZTYP_VERSIONEN.put(satzTypVersion, satz);
        }
        try {
            return (Satz)satz.clone();
        }
        catch (CloneNotSupportedException ex) {
            LOG.warn("Clone von {} hat nicht geklappt:", (Object)satz, (Object)ex);
            return SatzRegistry.getSatz(satzTypVersion);
        }
    }

    private static Satz getSatz(Map.Entry<SatzTyp, String> satzTypVersion) {
        SatzRegistry.createInstances();
        SatzTyp satzTyp = satzTypVersion.getKey();
        Satz satz = SatzRegistry.getInstance().getSatz(satzTyp);
        String version = satzTypVersion.getValue();
        float satzVersion = SatzRegistry.asFloat(satz.getVersion());
        float requiredVersion = SatzRegistry.asFloat(version);
        for (SatzRegistry registry : INSTANCES.values()) {
            try {
                Satz ds = registry.getSatz(satzTyp);
                if (version.equals(ds.getVersion())) {
                    return ds;
                }
                if (!(SatzRegistry.asFloat(ds.getVersion()) < satzVersion) || !(SatzRegistry.asFloat(ds.getVersion()) > requiredVersion)) continue;
                satz = ds;
                satzVersion = SatzRegistry.asFloat(ds.getVersion());
            }
            catch (NotRegisteredException e) {
                LOG.debug("Satzart {} in {} nicht registriert, suche weiter", (Object)satzTyp, (Object)registry);
                LOG.trace("Details:", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exakte Version {} fuer {} wurde nicht gefunden - verwende {} (Version {}).", (Object)version, (Object)satzTyp, (Object)satz.toShortString(), (Object)satz.getVersion());
        }
        return satz;
    }

    private static float asFloat(String version) {
        try {
            return Float.parseFloat(version);
        }
        catch (NumberFormatException ex) {
            LOG.info("Kann aus '{}' keine Version ermitteln ({}).", (Object)version, (Object)ex);
            LOG.debug("Details:", (Throwable)ex);
            return 0.0f;
        }
    }

    private static void createInstances() {
        SatzRegistry.getInstance(Config.VUVM2009);
        SatzRegistry.getInstance(Config.VUVM2013);
        SatzRegistry.getInstance(Config.VUVM2015);
        SatzRegistry.getInstance(Config.VUVM2018);
    }

    @Deprecated
    public void reset() {
        this.registeredSaetze.clear();
        LOG.debug("{} wurde zurueckgesetzt.", (Object)this);
    }

    public void register(Class<? extends Satz> clazz, int satzart) {
        this.register(clazz, satzart, VALIDATOR);
    }

    public void register(Class<? extends Satz> clazz, int satzart, Validator validator) {
        try {
            Constructor<? extends Satz> ctor = clazz.getConstructor(new Class[0]);
            LOG.debug("Default constructor {} found.", (Object)ctor);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("no default constructor found in " + clazz, ex);
        }
        SatzTyp satzTyp = SatzTyp.of(satzart);
        this.register(SatzRegistry.newInstance(satzTyp, clazz), satzTyp, validator);
    }

    public void register(Satz satz, SatzTyp satzNr) {
        this.register(satz, satzNr, VALIDATOR);
    }

    public void register(Satz satz, SatzTyp satzNr, Validator validator) {
        validator.validate(satzNr);
        this.registeredSaetze.put(satzNr, satz);
    }

    public void unregister(SatzTyp typ) {
        this.registeredSaetze.remove(typ);
        SATZTYP_VERSIONEN.clear();
    }

    public void register(Class<? extends Datensatz> clazz, SatzTyp satzNr) {
        this.registeredSaetze.put(satzNr, this.generateDatensatz(satzNr, clazz));
    }

    public Satz getSatz(SatzTyp satztyp) {
        Satz satz = this.registeredSaetze.get(satztyp);
        if (satz == null) {
            return this.getSatzFromXmlService(satztyp);
        }
        try {
            return (Satz)satz.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException(satztyp + " laesst sich nicht clonen", ex);
        }
    }

    private static Satz newInstance(SatzTyp satztyp, Class<? extends Satz> clazz) {
        try {
            Satz satz = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (satz.getSatzart() != satztyp.getSatzart()) {
                Constructor<? extends Satz> ctor = clazz.getConstructor(Integer.TYPE);
                satz = ctor.newInstance(satztyp.getSatzart());
            }
            return satz;
        }
        catch (Exception e) {
            LOG.info("default constructor does not work (" + e + "), trying another ctor...");
            Constructor<? extends Satz> ctor = null;
            try {
                ctor = clazz.getConstructor(Integer.TYPE);
                return ctor.newInstance(satztyp.getSatzart());
            }
            catch (InvocationTargetException ite) {
                throw new ShitHappenedException(ite.getTargetException() + " in " + ctor, ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new UnsupportedOperationException("registered " + clazz + " has not the required ctor", nsme);
            }
            catch (InstantiationException ie) {
                throw new ShitHappenedException("registered " + clazz + " can't be instantiated", ie);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException("registered " + clazz + " can't be accessed", iae);
            }
        }
    }

    private Satz getSatzFromXmlService(SatzTyp satztyp) {
        SatzXml satz = this.xmlService.getSatzart(satztyp);
        satz.init(satztyp);
        return satz;
    }

    public Satz getSatz(String content) {
        Satz satz;
        SatzTyp satzTyp;
        try {
            satzTyp = this.errateSatzTyp(content);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't recognize SatzTyp " + content, ioe);
        }
        try {
            satz = this.getSatz(satzTyp);
        }
        catch (NotRegisteredException e) {
            LOG.debug("Kann Satz '{}' nicht bestimmen und verwende Fallback:", (Object)satzTyp, (Object)e);
            satz = this.generateDatensatz(satzTyp);
        }
        try {
            satz.importFrom(content);
            return satz;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("can't parse " + content, ioe);
        }
    }

    private SatzTyp errateSatzTyp(String content) throws IOException {
        int satzart = Integer.parseInt(content.substring(0, 4));
        if (satzart == 1 || satzart == 9999) {
            return SatzTyp.of(satzart);
        }
        try (PushbackLineNumberReader reader = new PushbackLineNumberReader(new StringReader(content));){
            Satz satz = Datenpaket.importSatz(reader);
            SatzTyp satzTyp = satz.getSatzTyp();
            return satzTyp;
        }
    }

    public Vorsatz getVorsatz() {
        return new Vorsatz(this);
    }

    public Nachsatz getNachsatz() {
        return new Nachsatz(this);
    }

    @Deprecated
    public Datensatz getDatensatz(SatzTyp satzNr) {
        Satz satz = this.registeredSaetze.get(satzNr);
        if (satz instanceof Datensatz) {
            try {
                return (Datensatz)satz.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalArgumentException(satzNr + " laesst sich nicht clonen", ex);
            }
        }
        return this.generateDatensatz(satzNr);
    }

    private Datensatz generateDatensatz(SatzTyp satzNr, Class<? extends Datensatz> clazz) {
        try {
            Constructor<? extends Datensatz> ctor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
            return ctor.newInstance(satzNr.getSatzart(), satzNr.getSparte());
        }
        catch (NoSuchMethodException exWithTwoParams) {
            LOG.info("constructor " + clazz + "(int, int) not found (" + exWithTwoParams + ")");
            return SatzRegistry.getDatensatz(satzNr.getSparte(), clazz);
        }
        catch (InstantiationException exWithTwoParams) {
            LOG.info(clazz + "(int, int) can't be instantiated (" + exWithTwoParams + ")");
            return SatzRegistry.getDatensatz(satzNr.getSparte(), clazz);
        }
        catch (IllegalAccessException exWithTwoParams) {
            LOG.info(clazz + "(int, int) can't be accessed (" + exWithTwoParams + ")");
            return SatzRegistry.getDatensatz(satzNr.getSparte(), clazz);
        }
        catch (InvocationTargetException exWithTwoParams) {
            LOG.info("error in calling " + clazz + "(int, int): " + exWithTwoParams);
            return SatzRegistry.getDatensatz(satzNr.getSparte(), clazz);
        }
    }

    private static Datensatz getDatensatz(int sparte, Class<? extends Datensatz> clazz) {
        try {
            Constructor<? extends Datensatz> ctor = clazz.getConstructor(Integer.TYPE);
            return ctor.newInstance(sparte);
        }
        catch (NoSuchMethodException nsme) {
            LOG.info(clazz + " found but no " + clazz.getSimpleName() + "(" + sparte + ") constructor (" + nsme + ")");
            return SatzRegistry.getDatensatz(clazz);
        }
        catch (Exception exWithOneParam) {
            LOG.warn("constructor problem with " + clazz, (Throwable)exWithOneParam);
            return SatzRegistry.getDatensatz(clazz);
        }
    }

    private static Datensatz getDatensatz(Class<? extends Datensatz> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("can't instantiate " + clazz, e);
        }
    }

    private Datensatz generateDatensatz(SatzTyp satzNr) {
        try {
            Datensatz fallback = (Datensatz)this.getSatz(satzNr);
            if (satzNr.hasSparte()) {
                fallback.setSparte(satzNr.getSparte());
            }
            return fallback;
        }
        catch (NotRegisteredException re) {
            LOG.info("Datensatz fuer Satzart {} wird kreiert.", (Object)satzNr);
            LOG.debug("Details:", (Throwable)re);
            Datensatz satz = new Datensatz(SatzTyp.of(satzNr.getSatzart(), satzNr.getSparte()));
            satz.addFiller();
            return satz;
        }
    }

    public Datenpaket getAllSupportedSaetze() {
        HashMap<SatzTyp, Satz> supportedSaetze = new HashMap<SatzTyp, Satz>(this.xmlService.getSatzarten());
        for (Map.Entry<SatzTyp, Satz> entry : this.registeredSaetze.entrySet()) {
            Satz value = entry.getValue();
            if (!(value instanceof Datensatz)) continue;
            supportedSaetze.put(entry.getKey(), value);
        }
        return this.createDatenpaket(supportedSaetze);
    }

    public Datenpaket getSupportedSaetzeWith(SatzTyp ... typen) {
        HashMap<SatzTyp, Satz> supportedSaetze = new HashMap<SatzTyp, Satz>();
        for (SatzTyp t : typen) {
            supportedSaetze.put(t, this.xmlService.getSatzart(t));
        }
        return this.createDatenpaket(supportedSaetze);
    }

    private Datenpaket createDatenpaket(Map<SatzTyp, Satz> supportedSaetze) {
        supportedSaetze.remove(Vorsatz.SATZART);
        supportedSaetze.put(Vorsatz.SATZART, new Vorsatz(this));
        supportedSaetze.remove(Nachsatz.SATZART);
        supportedSaetze.put(Nachsatz.SATZART, new Nachsatz(this));
        return Datenpaket.of(supportedSaetze.values(), this.xmlService.getConfig());
    }

    public String getGdvRelease() {
        return this.xmlService.getGdvRelease();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " mit " + this.xmlService;
    }

    @Override
    public String getVersionOf(SatzTyp satzTyp) {
        return this.getSatz(satzTyp).getSatzversion().getInhalt();
    }

    static class Validator {
        private final Range<Integer> allowed;

        public Validator() {
            this(Range.between(800, 899));
        }

        public Validator(Range<Integer> allowed) {
            this.allowed = allowed;
        }

        public SatzTyp validate(SatzTyp x) {
            if (this.allowed.contains(x.getSatzart())) {
                return x;
            }
            throw new ValidationException(x.getSatzart() + " liegt ausserhalb von " + this.allowed);
        }
    }
}

