/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.io.Importer;
import gdv.xport.io.PushbackLineNumberReader;
import java.io.IOException;
import java.util.Arrays;
import javax.validation.ValidationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SatzTyp {
    private static final Validator VALIDATOR = new Validator();
    private final short[] teil;
    private static final int[] spartenIdentischZu_000 = new int[]{60, 63, 65, 69, 160, 161, 162, 169, 233, 240, 241, 242, 243, 249, 250, 251, 252, 290, 291, 293, 294, 296, 299, 630, 650};
    private static final int[] spartenIdentischZu_080 = new int[]{80, 81, 82, 83, 89, 90, 99, 100, 109, 120, 123, 124, 150, 210, 230, 231};
    private static final int[] spartenIdentischZu_170 = new int[]{170, 171, 172, 174, 175, 176, 179, 232};
    private static final int[] spartenIdentischZu_190 = new int[]{180, 181, 182, 183, 184, 185, 189, 190, 191, 192, 193, 194, 197, 199};
    private static final int[] spartenIdentischZu_510 = new int[]{241, 244, 510};

    public static SatzTyp of(String nr) {
        return SatzTyp.of(nr, ".");
    }

    private static SatzTyp of(String nr, String separatorChars) {
        return new SatzTyp(nr, separatorChars);
    }

    public static SatzTyp of(int ... args2) {
        switch (args2.length) {
            case 1: {
                return SatzTyp.of(String.format("%04d", args2[0]));
            }
            case 2: {
                return SatzTyp.of(String.format("%04d.%03d", args2[0], args2[1]));
            }
            case 3: {
                return SatzTyp.of(String.format("%04d.%03d.%d", args2[0], args2[1], args2[2]));
            }
            case 4: {
                return SatzTyp.of(String.format("%04d.%03d.%d.%d", args2[0], args2[1], args2[2], args2[3]));
            }
        }
        throw new IllegalArgumentException("1 - 4 arguments expected, not " + args2.length);
    }

    private SatzTyp(String nr, String separatorChars) {
        this(SatzTyp.toIntArray(nr, separatorChars));
    }

    private static int[] toIntArray(String nr, String separatorChars) {
        String[] parts = StringUtils.split(nr, separatorChars);
        int[] array = new int[parts.length];
        try {
            for (int i = 0; i < parts.length; ++i) {
                array[i] = Integer.parseInt(parts[i]);
            }
            return array;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("kein Satz-Typ: '" + nr + "'", ex);
        }
    }

    @Deprecated
    public SatzTyp(int ... args2) {
        this.teil = SatzTyp.createArray(VALIDATOR.verify(args2));
    }

    private static short[] createArray(int[] args2) {
        short[] array = new short[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            array[i] = (short)args2[i];
        }
        short satzart = array[0];
        if (array.length == 2 && satzart == 220 && array[1] == 10) {
            array = ArrayUtils.add(array, (short)0);
        }
        if (array.length == 3 && (satzart == 220 || satzart == 221) && array[1] == 10 && array[2] > 0) {
            array = ArrayUtils.add(array, (short)1);
        }
        return array;
    }

    private static boolean isAllgemeineSatzart(int satzart) {
        return satzart == 210 || satzart == 211 || satzart == 220 || satzart == 221;
    }

    @Deprecated
    public static SatzTyp readSatzTyp(PushbackLineNumberReader reader, int satzart) throws IOException {
        return Importer.of(reader).readSatzTyp(satzart);
    }

    private boolean isAllgemeineSatzart() {
        return SatzTyp.isAllgemeineSatzart(this.getSatzart());
    }

    public int getSatzart() {
        return this.teil[0];
    }

    public int getSparte() {
        return this.teil[1];
    }

    public String getSparteAsString() {
        return String.format("%03d", this.getSparte());
    }

    public String getSparteMitArt() {
        StringBuilder buf = new StringBuilder();
        String[] parts = StringUtils.split(this.getGdvSatzartName(), '.');
        if (parts.length > 1) {
            buf.append(parts[1]);
            if (this.hasArt()) {
                buf.append(".");
                buf.append(this.getArtAsString());
            }
        }
        return buf.toString();
    }

    public int getWagnisart() {
        this.assertTrue("Wagnisart", this.hasWagnisart());
        return this.teil[2];
    }

    public int getBausparenArt() {
        this.assertTrue("BausparenArt", this.hasBausparenArt());
        return this.teil[2];
    }

    public String getBausparenArtAsString() {
        if (!this.hasBausparenArt()) {
            return "";
        }
        if (this.getBausparenArt() == 0 || this.getBausparenArt() == 1) {
            return "01";
        }
        return Integer.toString(this.getBausparenArt());
    }

    public int getArt() {
        this.assertTrue("Art", this.hasArt());
        if (this.getSparte() == 10) {
            switch (this.getWagnisart()) {
                case 1: 
                case 3: {
                    return 13;
                }
                case 4: 
                case 8: {
                    return 48;
                }
            }
            return this.getWagnisart();
        }
        if (this.getSparte() == 20) {
            return this.getKrankenFolgeNr();
        }
        if (this.getSparte() == 580) {
            return this.getBausparenArt();
        }
        return -1;
    }

    String getArtAsString() {
        if (this.hasBausparenArt() && (this.getBausparenArt() == 0 || this.getBausparenArt() == 1)) {
            return "01";
        }
        return Integer.toString(this.getArt());
    }

    public boolean hasArt() {
        return this.hasWagnisart() || this.hasBausparenArt() || this.hasKrankenFolgeNr();
    }

    public int getKrankenFolgeNr() {
        this.assertTrue("KrankenFolgeNr", this.hasKrankenFolgeNr());
        return this.teil[2];
    }

    public int getTeildatensatzNummer() {
        this.assertTrue("TeildatensatzNummer", this.hasTeildatensatzNummer());
        return this.teil[3];
    }

    public int getGdvSatzartNummer() {
        this.assertTrue("GdvSatzartNummer", this.hasGdvSatzartNummer());
        return this.teil.length > 3 ? this.teil[3] : 0;
    }

    public boolean hasSparte() {
        return this.teil.length > 1 && this.teil[1] > 0;
    }

    @Deprecated
    public boolean hasParent() {
        return this.teil.length > 1;
    }

    @Deprecated
    public SatzTyp getParent() {
        String parent = StringUtils.substringBeforeLast(this.toString(), ".");
        return SatzTyp.of(parent);
    }

    public boolean hasWagnisart() {
        return this.teil.length > 2 && this.teil[2] >= 0 && this.getSparte() == 10;
    }

    public boolean hasKrankenFolgeNr() {
        return this.teil.length > 2 && this.teil[2] > 0 && this.getSparte() == 20;
    }

    public boolean hasBausparenArt() {
        return this.teil.length > 2 && this.teil[2] >= 0 && this.getSparte() == 580;
    }

    public boolean hasTeildatensatzNummer() {
        return this.teil.length > 3;
    }

    public boolean hasGdvSatzartNummer() {
        return this.teil.length > 3;
    }

    public String getGdvSatzartName() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%04d", this.getSatzart()));
        if (this.getSatzart() >= 210 && this.getSatzart() < 300) {
            if (this.hasSparte()) {
                buf.append(".");
                if (SatzTyp.isIdentischZu000(this.getSparte())) {
                    buf.append("000");
                } else if (SatzTyp.isIdentischZu080(this.getSparte())) {
                    buf.append("080");
                } else if (SatzTyp.isIdentischZu170(this.getSparte())) {
                    buf.append("170");
                } else if (SatzTyp.isIdentischZu190(this.getSparte())) {
                    buf.append("190");
                } else if (SatzTyp.isIdentischZu510(this.getSparte())) {
                    buf.append("510");
                } else if (600 == this.getSparte()) {
                    buf.append("050");
                } else {
                    buf.append(this.getSparteAsString());
                    if (this.hasArt()) {
                        buf.append(".");
                        buf.append(this.getArtAsString());
                    }
                    if (this.hasGdvSatzartNummer()) {
                        buf.append(".");
                        buf.append(this.getGdvSatzartNummer());
                    }
                }
            } else if (this.isAllgemeineSatzart()) {
                buf.append(".000");
            }
        }
        return buf.toString();
    }

    public boolean hasSparteInGdvSatzartName() {
        return StringUtils.split(this.getGdvSatzartName(), '.').length > 1;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SatzTyp)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        return this.getGdvSatzartName();
    }

    private void assertTrue(String attribute, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException(this + " hat keine " + attribute);
        }
    }

    private static boolean isIdentischZu000(int sparte) {
        boolean ret = false;
        for (int sparte000 : spartenIdentischZu_000) {
            if (sparte000 != sparte) continue;
            return true;
        }
        return ret;
    }

    private static boolean isIdentischZu080(int sparte) {
        boolean ret = false;
        for (int sparte000 : spartenIdentischZu_080) {
            if (sparte000 != sparte) continue;
            return true;
        }
        return ret;
    }

    private static boolean isIdentischZu170(int sparte) {
        boolean ret = false;
        for (int sparte170 : spartenIdentischZu_170) {
            if (sparte170 != sparte) continue;
            return true;
        }
        return ret;
    }

    private static boolean isIdentischZu190(int sparte) {
        boolean ret = false;
        for (int sparte190 : spartenIdentischZu_190) {
            if (sparte190 != sparte) continue;
            return true;
        }
        return ret;
    }

    private static boolean isIdentischZu510(int sparte) {
        boolean ret = false;
        for (int sparte510 : spartenIdentischZu_510) {
            if (sparte510 != sparte) continue;
            return true;
        }
        return ret;
    }

    public static class Validator {
        public int[] validate(int[] args2) {
            Validator.validateLength(args2, 4);
            switch (args2[0]) {
                case 1: 
                case 9999: {
                    Validator.validateLength(args2, 1);
                    break;
                }
                case 52: 
                case 100: 
                case 102: 
                case 200: 
                case 202: 
                case 210: 
                case 211: 
                case 212: 
                case 222: 
                case 225: 
                case 230: 
                case 250: 
                case 251: 
                case 260: 
                case 270: 
                case 280: 
                case 291: 
                case 292: 
                case 293: 
                case 294: 
                case 295: 
                case 300: 
                case 342: 
                case 350: 
                case 352: 
                case 362: 
                case 372: 
                case 382: 
                case 390: 
                case 392: 
                case 400: 
                case 410: 
                case 420: 
                case 430: 
                case 450: 
                case 500: 
                case 550: 
                case 600: 
                case 9950: 
                case 9951: 
                case 9952: {
                    Validator.validateLength(args2, 2);
                    break;
                }
                case 220: {
                    this.validateSatzart0220(args2);
                    break;
                }
                case 221: {
                    this.validateSatzart0221(args2);
                }
            }
            return args2;
        }

        private static void validateLength(int[] args2, int max) {
            if (args2.length < 1 || args2.length > max) {
                throw new ValidationException("array " + Arrays.toString(args2) + ": expected size is 1.." + max);
            }
        }

        private void validateSatzart0220(int[] args2) {
            if (args2.length > 1) {
                switch (args2[1]) {
                    case 0: 
                    case 30: 
                    case 40: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 59: 
                    case 70: 
                    case 80: 
                    case 110: 
                    case 130: 
                    case 140: 
                    case 170: 
                    case 190: 
                    case 510: 
                    case 550: 
                    case 560: 
                    case 570: 
                    case 684: {
                        Validator.validateLength(args2, 2);
                        break;
                    }
                    case 20: 
                    case 580: {
                        Validator.validateLength(args2, 3);
                    }
                }
            }
        }

        private void validateSatzart0221(int[] args2) {
            if (args2.length > 1) {
                switch (args2[1]) {
                    case 0: 
                    case 30: 
                    case 40: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 59: 
                    case 70: 
                    case 80: 
                    case 110: 
                    case 130: 
                    case 140: 
                    case 170: 
                    case 190: 
                    case 510: 
                    case 550: 
                    case 560: 
                    case 570: 
                    case 684: {
                        Validator.validateLength(args2, 2);
                    }
                }
            }
        }

        public int[] verify(int[] args2) {
            try {
                return this.validate(args2);
            }
            catch (ValidationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

