/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.util;

import gdv.xport.feld.Feld;
import gdv.xport.satz.Satz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.oval.Check;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.context.ClassContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SimpleConstraintViolation
extends ConstraintViolation {
    private static final Logger LOG = LogManager.getLogger(SimpleConstraintViolation.class);
    private final List<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();

    public SimpleConstraintViolation(Feld validatedObject, Throwable cause) {
        this(cause.getLocalizedMessage(), validatedObject);
        LOG.debug("{} is not valid:", (Object)validatedObject, (Object)cause);
    }

    public SimpleConstraintViolation(String message, Feld validatedObject) {
        this(message, validatedObject, validatedObject.getInhalt());
    }

    public SimpleConstraintViolation(String message, Object validatedObject, Object invalidValue) {
        super((Check)new AssertValidCheck(), message, validatedObject, invalidValue, new ClassContext(validatedObject.getClass()));
    }

    public SimpleConstraintViolation(Satz satz, List<ConstraintViolation> violations) {
        this(String.format("%s: %d Problem(e)", satz.toShortString(), violations.size()), satz, violations);
        this.violations.addAll(violations);
    }

    public List<ConstraintViolation> getViolations() {
        return Collections.unmodifiableList(this.violations);
    }

    @Override
    public String toString() {
        return this.getValidatedObject() + " -> " + this.getMessage();
    }

    public static String toString(List<ConstraintViolation> violations) {
        StringBuilder buf = new StringBuilder();
        for (ConstraintViolation cv : violations) {
            if (cv.getInvalidValue() instanceof List) {
                buf.append(cv.getValidatedObject()).append(":\n");
                List cvViolations = (List)cv.getInvalidValue();
                for (Object cvViolation : cvViolations) {
                    buf.append("\t- ").append(cvViolation);
                }
            } else {
                buf.append(cv);
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

