/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.oval.Validator;
import net.sf.oval.exception.AccessingFieldValueFailedException;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.InvokingMethodFailedException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ArrayUtils;

public final class ReflectionUtils {
    private static final Log LOG = Log.getLog(ReflectionUtils.class);
    private static final ReflectPermission SUPPRESS_ACCESS_CHECKS_PERMISSION = new ReflectPermission("suppressAccessChecks");

    public static void assertPrivateAccessAllowed() throws ReflectionException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(SUPPRESS_ACCESS_CHECKS_PERMISSION);
            }
            catch (SecurityException ex) {
                throw new ReflectionException("Current security manager configuration does not allow access to private fields and methods.", ex);
            }
        }
    }

    public static Annotation[] getAnnotations(Class<?> clazz, boolean inspectInterfaces, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        if (!inspectInterfaces) {
            return clazz.getAnnotations();
        }
        List<Annotation> annotations = ArrayUtils.asList(clazz.getAnnotations());
        for (Class<?> next : ReflectionUtils.getInterfacesRecursive(clazz, includedInterfaces, excludedInterfaces)) {
            Annotation[] declaredAnnotations = next.getDeclaredAnnotations();
            Collections.addAll(annotations, declaredAnnotations);
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public static Annotation[] getAnnotations(Method method, boolean inspectInterfaces, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        if (!inspectInterfaces || !ReflectionUtils.isPublic(method)) {
            return method.getAnnotations();
        }
        String methodName = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        List<Annotation> annotations = ArrayUtils.asList(method.getAnnotations());
        for (Class<?> nextClass : ReflectionUtils.getInterfacesRecursive(method.getDeclaringClass(), includedInterfaces, excludedInterfaces)) {
            try {
                Collections.addAll(annotations, nextClass.getDeclaredMethod(methodName, methodParameterTypes).getDeclaredAnnotations());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getFieldForSetter(Method setter) {
        if (!ReflectionUtils.isSetter(setter)) {
            return null;
        }
        Class<?>[] methodParameterTypes = setter.getParameterTypes();
        String methodName = setter.getName();
        Class<?> clazz = setter.getDeclaringClass();
        String fieldName = methodName.substring(3, 4).toLowerCase(Validator.getLocaleProvider().getLocale());
        if (methodName.length() > 4) {
            fieldName = String.valueOf(fieldName) + methodName.substring(4);
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (!field.getType().equals(methodParameterTypes[0])) {
                LOG.warn("Found field <{1}> in class <{2}>that matches setter <{3}> name, but mismatches parameter type.", (Object)fieldName, (Object)clazz.getName(), methodName);
                field = null;
            }
        }
        catch (NoSuchFieldException e) {
            LOG.debug("Field not found", e);
        }
        if (field == null && (Boolean.TYPE.equals(methodParameterTypes[0]) || Boolean.class.equals(methodParameterTypes[0]))) {
            fieldName = "is" + methodName.substring(3);
            try {
                field = clazz.getDeclaredField(fieldName);
                if (!Boolean.TYPE.equals(field.getType()) && Boolean.class.equals(field.getType())) {
                    LOG.warn("Found field <{1}> in class <{2}>that matches setter <{3}> name, but mismatches parameter type.", (Object)fieldName, (Object)clazz.getName(), methodName);
                    field = null;
                }
            }
            catch (NoSuchFieldException ex) {
                LOG.debug("Field not found", ex);
            }
        }
        return field;
    }

    public static Field getFieldRecursive(Class<?> clazz, String fieldName) {
        Field f = ReflectionUtils.getField(clazz, fieldName);
        if (f != null) {
            return f;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getFieldRecursive(superclazz, fieldName);
    }

    public static Object getFieldValue(Field field, Object target) throws AccessingFieldValueFailedException {
        try {
            ReflectionUtils.setAccessible(field, true);
            return field.get(target);
        }
        catch (Exception ex) {
            throw new AccessingFieldValueFailedException(field.getName(), target, ContextCache.getFieldContext(field), ex);
        }
    }

    public static Method getGetter(Class<?> clazz, String propertyName) {
        String appendix = String.valueOf(propertyName.substring(0, 1).toUpperCase(Validator.getLocaleProvider().getLocale())) + propertyName.substring(1);
        try {
            return clazz.getDeclaredMethod("get" + appendix, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("getXXX method not found.", ex);
            try {
                return clazz.getDeclaredMethod("is" + appendix, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                LOG.trace("isXXX method not found.", ex2);
                return null;
            }
        }
    }

    public static Method getGetterRecursive(Class<?> clazz, String propertyName) {
        Method m = ReflectionUtils.getGetter(clazz, propertyName);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getGetterRecursive(superclazz, propertyName);
    }

    public static List<Method> getInterfaceMethods(Method method, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        if (ReflectionUtils.isStatic(method)) {
            return Collections.emptyList();
        }
        Set<Class<?>> interfaces = ReflectionUtils.getInterfacesRecursive(method.getDeclaringClass(), includedInterfaces, excludedInterfaces);
        if (interfaces.isEmpty()) {
            return Collections.emptyList();
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Method> methods = Validator.getCollectionFactory().createList(interfaces.size());
        for (Class<?> iface : interfaces) {
            Method m = ReflectionUtils.getMethod(iface, methodName, parameterTypes);
            if (m == null) continue;
            methods.add(m);
        }
        return methods;
    }

    private static Set<Class<?>> getInterfacesRecursive(Class<?> clazz, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        Set<Class<?>> interfaces = Validator.getCollectionFactory().createSet(2);
        return ReflectionUtils.getInterfacesRecursive(clazz, interfaces, includedInterfaces == null ? Collections.emptySet() : includedInterfaces, excludedInterfaces == null ? Collections.emptySet() : excludedInterfaces);
    }

    private static Set<Class<?>> getInterfacesRecursive(Class<?> clazz, Set<Class<?>> result, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> next = classArray[n2];
                if ((includedInterfaces.isEmpty() || includedInterfaces.contains(next)) && !excludedInterfaces.contains(next)) {
                    result.add(next);
                    ReflectionUtils.getInterfacesRecursive(next, result, includedInterfaces, excludedInterfaces);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethodRecursive(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getMethodRecursive(superclazz, methodName, parameterTypes);
    }

    public static Annotation[][] getParameterAnnotations(Method method, boolean inspectInterfaces, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        if (!inspectInterfaces || !ReflectionUtils.isPublic(method)) {
            return method.getParameterAnnotations();
        }
        String methodName = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        int methodParameterTypesCount = methodParameterTypes.length;
        HashSet[] methodParameterAnnotations = new HashSet[methodParameterTypesCount];
        Class<?> clazz = method.getDeclaringClass();
        Set<Class<?>> classes = ReflectionUtils.getInterfacesRecursive(clazz, includedInterfaces, excludedInterfaces);
        classes.add(clazz);
        for (Class<?> nextClass : classes) {
            try {
                Method nextMethod = nextClass.getDeclaredMethod(methodName, methodParameterTypes);
                int i = 0;
                while (i < methodParameterTypesCount) {
                    Annotation[] paramAnnos = nextMethod.getParameterAnnotations()[i];
                    if (paramAnnos.length > 0) {
                        HashSet cummulatedParamAnnos = methodParameterAnnotations[i];
                        if (cummulatedParamAnnos == null) {
                            methodParameterAnnotations[i] = cummulatedParamAnnos = new HashSet();
                        }
                        Collections.addAll(cummulatedParamAnnos, paramAnnos);
                    }
                    ++i;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Annotation[][] result = new Annotation[methodParameterTypesCount][];
        int i = 0;
        while (i < methodParameterTypesCount) {
            HashSet paramAnnos = methodParameterAnnotations[i];
            result[i] = paramAnnos == null ? new Annotation[]{} : methodParameterAnnotations[i].toArray(new Annotation[methodParameterAnnotations[i].size()]);
            ++i;
        }
        return result;
    }

    private static Method getSetter(Class<?> clazz, String propertyName) {
        Method[] declaredMethods;
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Validator.getLocaleProvider().getLocale()) + propertyName.substring(1);
        Method[] methodArray = declaredMethods = clazz.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++n2;
        }
        LOG.trace("No setter for {} not found on class {}.", (Object)propertyName, clazz);
        return null;
    }

    private static Method getSetterRecursive(Class<?> clazz, String propertyName) {
        Method m = ReflectionUtils.getSetter(clazz, propertyName);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getSetterRecursive(superclazz, propertyName);
    }

    public static Class<?> getTypeArgument(Field field, int typeIndex) {
        Type t;
        ParameterizedType parameterizedType;
        Type[] typeArgs;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (typeArgs = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > typeIndex && (t = typeArgs[typeIndex]) instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static Class<?> getTypeArgument(Method method, int parameterIndex, int typeIndex) {
        Type t;
        ParameterizedType parameterizedType;
        Type[] typeArgs;
        Type genericType = method.getGenericParameterTypes()[parameterIndex];
        if (genericType instanceof ParameterizedType && (typeArgs = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > typeIndex && (t = typeArgs[typeIndex]) instanceof Class) {
            return (Class)t;
        }
        return null;
    }

    public static String guessFieldName(Method getter) {
        String fieldName = getter.getName();
        if (fieldName.startsWith("get") && fieldName.length() > 3) {
            fieldName = (fieldName = fieldName.substring(3)).length() == 1 ? fieldName.toLowerCase(Validator.getLocaleProvider().getLocale()) : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
        } else if (fieldName.startsWith("is") && fieldName.length() > 2) {
            fieldName = (fieldName = fieldName.substring(2)).length() == 1 ? fieldName.toLowerCase(Validator.getLocaleProvider().getLocale()) : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
        }
        return fieldName;
    }

    public static <T> T invokeMethod(Method method, Object obj, Object ... args2) throws InvokingMethodFailedException, ConstraintsViolatedException {
        try {
            ReflectionUtils.setAccessible(method, true);
            return (T)method.invoke(obj, args2);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ConstraintsViolatedException) {
                throw (ConstraintsViolatedException)ex.getCause();
            }
            throw new InvokingMethodFailedException("Executing method " + method.getName() + " failed.", obj, ContextCache.getMethodReturnValueContext(method), ex);
        }
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass, boolean inspectInterfaces, Set<Class<?>> includedInterfaces, Set<Class<?>> excludedInterfaces) {
        if (method.isAnnotationPresent(annotationClass)) {
            return true;
        }
        if (!inspectInterfaces || !ReflectionUtils.isPublic(method)) {
            return false;
        }
        String methodName = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        for (Class<?> next : ReflectionUtils.getInterfacesRecursive(method.getDeclaringClass(), includedInterfaces, excludedInterfaces)) {
            try {
                if (!next.getDeclaredMethod(methodName, methodParameterTypes).isAnnotationPresent(annotationClass)) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return false;
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError ex) {
            LOG.error("Failed to load class [" + className + "]", ex);
            return false;
        }
    }

    public static boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && (method.getName().startsWith("is") || method.getName().startsWith("get"));
    }

    public static boolean isPrivate(Member member) {
        return (member.getModifiers() & 2) != 0;
    }

    public static boolean isProtected(Member member) {
        return (member.getModifiers() & 4) != 0;
    }

    private static boolean isPublic(Member member) {
        return (member.getModifiers() & 1) != 0;
    }

    private static boolean isSetter(Method method) {
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (methodParameterTypes.length != 1) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLen = methodName.length();
        return methodNameLen >= 4 && methodName.startsWith("set");
    }

    public static boolean isStatic(Member member) {
        return (member.getModifiers() & 8) != 0;
    }

    public static boolean isVoidMethod(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public static void setAccessible(AccessibleObject obj, boolean accessible) {
        if (obj.isAccessible() == accessible) {
            return;
        }
        AccessController.doPrivileged(() -> {
            obj.setAccessible(accessible);
            return null;
        });
    }

    public static boolean setViaSetter(Object target, String propertyName, Object propertyValue) {
        Method setter = ReflectionUtils.getSetterRecursive(target.getClass(), propertyName);
        if (setter != null) {
            try {
                setter.invoke(target, propertyValue);
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
            }
        }
        return false;
    }

    private ReflectionUtils() {
    }
}

