/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.map.BaseHashMap;

public class IntHashSet
extends BaseHashMap {
    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int n) throws IllegalArgumentException {
        super(n, 1, 0, false);
    }

    public IntHashSet(int[] nArray) {
        super(nArray.length, 1, 0, false);
        this.addAll(nArray);
    }

    public IntHashSet(int[] nArray, int[] nArray2) {
        super(nArray.length + nArray2.length, 1, 0, false);
        this.addAll(nArray);
        this.addAll(nArray2);
    }

    public boolean contains(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.containsKey(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean contains(int n) {
        return super.containsKey(n);
    }

    public boolean add(Integer n) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        return this.add(n2);
    }

    public boolean add(int n) {
        return (Boolean)super.addOrUpdate(n, 0L, null, null);
    }

    public boolean remove(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.remove(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean remove(int n) {
        return (Boolean)super.remove(n, 0L, null, null, false, false);
    }

    public int getStartMatchCount(int[] nArray) {
        int n;
        for (n = 0; n < nArray.length && super.containsKey(nArray[n]); ++n) {
        }
        return n;
    }

    public boolean addAll(Collection<? extends Integer> collection) {
        int n = this.size();
        Iterator<? extends Integer> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            this.add(iterator2.next());
        }
        return n != this.size();
    }

    public boolean addAll(IntHashSet intHashSet) {
        boolean bl = false;
        PrimitiveIterator<Integer> primitiveIterator = intHashSet.iterator();
        while (primitiveIterator.hasNext()) {
            bl |= this.add(primitiveIterator.nextInt());
        }
        return bl;
    }

    public boolean addAll(int[] nArray) {
        int n = this.size();
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
        return n != this.size();
    }

    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            if (this.contains(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection<?> collection) {
        int n = this.size();
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this, true);
        while (baseHashIterator.hasNext()) {
            if (collection.contains(baseHashIterator.nextInt())) continue;
            baseHashIterator.remove();
        }
        return n != this.size();
    }

    public boolean removeAll(Collection<?> collection) {
        int n = this.size();
        Iterator<?> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            Object obj = iterator2.next();
            if (!(obj instanceof Integer)) continue;
            this.remove(obj);
        }
        return n != this.size();
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        return this.toIntArray(nArray, true);
    }

    public int[] toArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public PrimitiveIterator<Integer> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }
}

