/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyHashMap<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;

    public IntKeyHashMap() {
        this(8);
    }

    public IntKeyHashMap(int n) throws IllegalArgumentException {
        super(n, 1, 3, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.containsKey(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int n) {
        return super.containsKey(n);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.get(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V get(int n) {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            return (V)this.objectValueTable[n2];
        }
        return null;
    }

    @Override
    public V put(Integer n, V v) {
        if (n == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        return this.put(n2, v);
    }

    @Override
    public V put(int n, V v) {
        return (V)super.addOrUpdate(n, 0L, null, v);
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.remove(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(int n) {
        return (V)super.remove(n, 0L, null, null, false, false);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        Iterator iterator2 = map.keySet().iterator();
        while (iterator2.hasNext()) {
            Integer n = (Integer)iterator2.next();
            if (n == null) continue;
            int n2 = n;
            this.put(n2, map.get(n));
        }
    }

    public void putAll(IntKeyHashMap intKeyHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            int n = primitiveIterator.nextInt();
            this.put(n, intKeyHashMap.get(n));
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            Objects.requireNonNull(intKeyHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return IntKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return IntKeyHashMap.this.toArray(TArray, false);
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            Objects.requireNonNull(intKeyHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer n = super.nextInt();
            Object object = IntKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(n, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

