/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import com.github.odavid.maven.plugins.Mixin;
import com.github.odavid.maven.plugins.MixinModelMerger;
import com.github.odavid.maven.plugins.MixinModelProblemCollector;
import com.github.odavid.maven.plugins.Mixins;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.configuration.DefaultBeanConfigurationRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.plugin.PluginConfigurationExpander;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="MixinMavenLifecycleParticipant")
public class MixinMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_GROUPID = "com.github.odavid.maven.plugins";
    private static final String PLUGIN_ARTIFACTID = "mixin-maven-plugin";
    private final MavenXpp3Reader mavenXpp3reader = new MavenXpp3Reader();
    private final MixinModelMerger mixinModelMerger = new MixinModelMerger();
    @Requirement
    protected Logger logger;
    @Requirement
    protected RepositorySystem repositorySystem;
    @Requirement
    private BeanConfigurator beanConfigurator;
    @Requirement
    private ModelInterpolator modelInterpolator;
    @Requirement
    private PluginConfigurationExpander pluginConfigurationExpander;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
    }

    public void afterProjectsRead(MavenSession mavenSession) throws MavenExecutionException {
        this.logger.info(String.format("%s: Merging Mixins", PLUGIN_ARTIFACTID));
        List projects = mavenSession.getProjects();
        for (MavenProject module : projects) {
            this.mergeMixins(module, mavenSession);
        }
        mavenSession.setProjects(projects);
        this.logger.info(String.format("%s: Mixins were merged", PLUGIN_ARTIFACTID));
    }

    private void mergeMixins(MavenProject currentProject, MavenSession mavenSession) throws MavenExecutionException {
        List plugins = currentProject.getBuildPlugins();
        for (Plugin plugin : plugins) {
            if (!plugin.getGroupId().equals(PLUGIN_GROUPID) || !plugin.getArtifactId().equals(PLUGIN_ARTIFACTID)) continue;
            this.logger.info(String.format("%s: Processing Mixins for %s", PLUGIN_ARTIFACTID, currentProject.getFile()));
            Mixins mixins = this.loadConfiguration(plugin.getConfiguration());
            for (Mixin mixin : mixins.getMixins()) {
                mixin.merge(currentProject, mavenSession, plugin, this.mixinModelMerger, this.mavenXpp3reader, this.repositorySystem);
            }
            if (mixins.getMixins().size() > 0) {
                ProjectBuildingRequest projectBuildingRequest = mavenSession.getProjectBuildingRequest();
                DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
                request.setActiveProfileIds(projectBuildingRequest.getActiveProfileIds());
                request.setInactiveProfileIds(projectBuildingRequest.getInactiveProfileIds());
                request.setBuildStartTime(projectBuildingRequest.getBuildStartTime());
                MixinModelProblemCollector problems = new MixinModelProblemCollector();
                this.modelInterpolator.interpolateModel(currentProject.getModel(), currentProject.getBasedir(), (ModelBuildingRequest)request, (ModelProblemCollector)problems);
                this.pluginConfigurationExpander.expandPluginConfiguration(currentProject.getModel(), (ModelBuildingRequest)request, (ModelProblemCollector)problems);
                problems.checkErrors(currentProject.getFile());
            }
            this.logger.info(String.format("%s: Mixins merged successfuly for %s", PLUGIN_ARTIFACTID, currentProject.getFile()));
            break;
        }
    }

    private Mixins loadConfiguration(Object configuration) throws MavenExecutionException {
        Mixins mixins = new Mixins();
        DefaultBeanConfigurationRequest request = new DefaultBeanConfigurationRequest();
        request.setBean((Object)mixins);
        request.setConfiguration(configuration, "mixins");
        try {
            this.beanConfigurator.configureBean((BeanConfigurationRequest)request);
            return mixins;
        }
        catch (BeanConfigurationException e) {
            throw new MavenExecutionException("Cannot load mixins configuration: " + e.getMessage(), (Throwable)e);
        }
    }
}

