/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.merge.MavenModelMerger;

public class MixinModelMerger
extends MavenModelMerger {
    public void mergePluginManagement(Model target, Model source) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (source.getBuild() != null && source.getBuild().getPluginManagement() != null) {
            if (target.getBuild() == null) {
                target.setBuild(new Build());
            }
            if (target.getBuild().getPluginManagement() == null) {
                target.getBuild().setPluginManagement(new PluginManagement());
            }
            PluginManagement sourceContainer = source.getBuild().getPluginManagement();
            PluginManagement targetContainer = target.getBuild().getPluginManagement();
            this.mergePluginContainers((PluginContainer)targetContainer, (PluginContainer)sourceContainer, context, true);
        }
    }

    public void mergePlugins(Model target, Model source) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (source.getBuild() != null) {
            if (target.getBuild() == null) {
                target.setBuild(new Build());
            }
            Build sourceContainer = source.getBuild();
            Build targetContainer = target.getBuild();
            this.mergePluginContainers((PluginContainer)targetContainer, (PluginContainer)sourceContainer, context, true);
            this.mergePluginContainers((PluginContainer)targetContainer, (PluginContainer)target.getBuild().getPluginManagement(), context, false);
        }
    }

    public void mergeProperties(Model target, Model source) {
        HashMap context = new HashMap();
        if (source.getProperties() != null) {
            super.mergeModelBase_Properties((ModelBase)target, (ModelBase)source, false, context);
        }
    }

    private void mergePluginContainers(PluginContainer targetContainer, PluginContainer sourceContainer, Map<Object, Object> context, boolean addTargetPlugin) {
        List plugins = sourceContainer.getPlugins();
        for (Plugin sourcePlugin : plugins) {
            Plugin targetPlugin = (Plugin)targetContainer.getPluginsAsMap().get(sourcePlugin.getKey());
            if (targetPlugin == null) {
                if (!addTargetPlugin) continue;
                targetContainer.getPlugins().add(sourcePlugin);
                continue;
            }
            for (PluginExecution sourceExecution : sourcePlugin.getExecutions()) {
                PluginExecution targetPluginExecution = (PluginExecution)targetPlugin.getExecutionsAsMap().get(sourceExecution.getId());
                if (targetPluginExecution == null) {
                    targetPlugin.addExecution(sourceExecution);
                    continue;
                }
                super.mergePluginExecution(targetPluginExecution, sourceExecution, false, context);
            }
            if (targetPlugin.getConfiguration() == null) {
                targetPlugin.setConfiguration(sourcePlugin.getConfiguration());
                continue;
            }
            super.mergePlugin(targetPlugin, sourcePlugin, false, context);
        }
    }
}

