/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;

public class MixinModelProblemCollector
implements ModelProblemCollector {
    List<ModelProblemCollectorRequest> problems = new ArrayList<ModelProblemCollectorRequest>();
    private Set<ModelProblem.Severity> severities = EnumSet.noneOf(ModelProblem.Severity.class);

    public void add(ModelProblemCollectorRequest req) {
        this.problems.add(req);
        this.severities.add(req.getSeverity());
    }

    public void checkErrors(File pom) throws MavenExecutionException {
        if (this.severities.contains(ModelProblem.Severity.ERROR) || this.severities.contains(ModelProblem.Severity.FATAL)) {
            PrintWriter out = new PrintWriter(new StringWriter());
            for (ModelProblemCollectorRequest request : this.problems) {
                out.printf("Model Problem: %s%n", request.getMessage());
            }
            throw new MavenExecutionException(out.toString(), pom);
        }
    }
}

