/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.merge.MavenModelMerger;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MixinModelMerger.class)
public class MixinModelMerger
extends MavenModelMerger {
    public void mergePluginManagement(Model target, Model source) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (source.getBuild() != null && source.getBuild().getPluginManagement() != null) {
            if (target.getBuild() == null) {
                target.setBuild(new Build());
            }
            if (target.getBuild().getPluginManagement() == null) {
                target.getBuild().setPluginManagement(new PluginManagement());
            }
            PluginManagement sourceContainer = source.getBuild().getPluginManagement();
            PluginManagement targetContainer = target.getBuild().getPluginManagement();
            this.mergePluginContainers((PluginContainer)targetContainer, (PluginContainer)sourceContainer, context, true);
        }
    }

    public void applyPluginManagementOnPlugins(Model model) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        this.mergePluginContainers((PluginContainer)model.getBuild(), (PluginContainer)model.getBuild().getPluginManagement(), context, false);
    }

    public void mergePlugins(Model target, Model source) {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        if (source.getBuild() != null) {
            if (target.getBuild() == null) {
                target.setBuild(new Build());
            }
            Build sourceContainer = source.getBuild();
            Build targetContainer = target.getBuild();
            this.mergePluginContainers((PluginContainer)targetContainer, (PluginContainer)sourceContainer, context, true);
        }
    }

    public void mergeProperties(Model target, Model source) {
        HashMap context = new HashMap();
        if (source.getProperties() != null) {
            super.mergeModelBase_Properties((ModelBase)target, (ModelBase)source, false, context);
        }
    }

    private void mergePluginContainers(PluginContainer targetContainer, PluginContainer sourceContainer, Map<Object, Object> context, boolean addTargetPlugin) {
        List plugins = sourceContainer.getPlugins();
        for (Plugin sourcePlugin : plugins) {
            String key = sourcePlugin.getKey();
            Plugin targetPlugin = null;
            for (Plugin targetPluginElement : targetContainer.getPlugins()) {
                if (targetPluginElement.getKey() == null || !targetPluginElement.getKey().equals(key)) continue;
                targetPlugin = targetPluginElement;
                break;
            }
            if (targetPlugin == null) {
                if (!addTargetPlugin) continue;
                targetContainer.getPlugins().add(sourcePlugin.clone());
                continue;
            }
            for (PluginExecution sourceExecution : sourcePlugin.getExecutions()) {
                String executionId = sourceExecution.getId();
                PluginExecution targetPluginExecution = null;
                for (PluginExecution targetExecution : targetPlugin.getExecutions()) {
                    if (targetExecution.getId() == null || !targetExecution.getId().equals(executionId)) continue;
                    targetPluginExecution = targetExecution;
                    break;
                }
                if (targetPluginExecution == null) {
                    targetPlugin.addExecution(sourceExecution.clone());
                    continue;
                }
                super.mergePluginExecution(targetPluginExecution, sourceExecution, false, context);
            }
            super.mergeConfigurationContainer((ConfigurationContainer)targetPlugin, (ConfigurationContainer)sourcePlugin, false, context);
            super.mergePlugin_GroupId(targetPlugin, sourcePlugin, false, context);
            super.mergePlugin_ArtifactId(targetPlugin, sourcePlugin, false, context);
            super.mergePlugin_Version(targetPlugin, sourcePlugin, false, context);
            super.mergePlugin_Extensions(targetPlugin, sourcePlugin, false, context);
            super.mergePlugin_Dependencies(targetPlugin, sourcePlugin, false, context);
        }
    }
}

