/*
 * Decompiled with CFR 0.152.
 */
package com.github.odavid.maven.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="package-mixin", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class PackageMixinMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(readonly=true, defaultValue="${project.basedir}/mixin.xml")
    private File mixinFile;
    private final MavenXpp3Reader mavenXpp3reader = new MavenXpp3Reader();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.mixinFile.exists()) {
            throw new MojoExecutionException("Cannot find file: " + this.mixinFile);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.mixinFile);
            Model model = this.mavenXpp3reader.read((InputStream)is);
            this.mavenProject.getArtifact().setFile(this.mixinFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load file: " + this.mixinFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Cannot parse file: " + this.mixinFile, (Exception)((Object)e));
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

