/*
 * Decompiled with CFR 0.152.
 */
package com.github.odiszapc.nginxparser;

import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class NgxAbstractEntry
implements NgxEntry {
    private Collection<NgxToken> tokens = new ArrayList<NgxToken>();

    public NgxAbstractEntry(String ... rawValues) {
        for (String val : rawValues) {
            this.tokens.add(new NgxToken(val));
        }
    }

    public Collection<NgxToken> getTokens() {
        return this.tokens;
    }

    public void addValue(NgxToken token) {
        this.tokens.add(token);
    }

    public void addValue(String value) {
        this.addValue(new NgxToken(value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (NgxToken value : this.tokens) {
            builder.append(value).append(" ");
        }
        String s = builder.toString();
        return s.substring(0, s.length() - 1);
    }

    public String getName() {
        if (this.getTokens().isEmpty()) {
            return null;
        }
        return this.getTokens().iterator().next().toString();
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        if (this.getTokens().size() < 2) {
            return values;
        }
        Iterator<NgxToken> it = this.getTokens().iterator();
        it.next();
        while (it.hasNext()) {
            values.add(it.next().toString());
        }
        return values;
    }

    public String getValue() {
        Iterator<String> iterator = this.getValues().iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(' ');
        }
        return builder.toString();
    }
}

