/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.DnsRecord;
import io.omam.halo.MessageOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;

final class AddressRecord
extends DnsRecord {
    private final InetAddress address;

    AddressRecord(String aName, short aClass, Duration aTtl, Instant now, InetAddress anAddress) {
        super(aName, AddressRecord.type(anAddress), aClass, aTtl, now);
        this.address = anAddress;
    }

    private static short type(InetAddress address) {
        return address instanceof Inet4Address ? (short)1 : 28;
    }

    public final String toString() {
        return "AddressRecord [name=" + this.name() + ", type=" + this.type() + ", class=" + this.clazz() + ", ttl=" + this.ttl() + ", address=" + this.address + "]";
    }

    final InetAddress address() {
        return this.address;
    }

    @Override
    protected void write(MessageOutputStream mos) {
        mos.writeAllBytes(this.address.getAddress());
    }
}

