/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.AddressRecord;
import io.omam.halo.Attributes;
import io.omam.halo.DnsMessage;
import io.omam.halo.DnsQuestion;
import io.omam.halo.DnsRecord;
import io.omam.halo.HaloHelper;
import io.omam.halo.HaloProperties;
import io.omam.halo.MulticastDnsSd;
import io.omam.halo.PtrRecord;
import io.omam.halo.RegisterableService;
import io.omam.halo.RegisteredService;
import io.omam.halo.ResponseListener;
import io.omam.halo.SequentialBatchExecutor;
import io.omam.halo.Service;
import io.omam.halo.SrvRecord;
import io.omam.halo.Timeout;
import io.omam.halo.TxtRecord;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Announcer
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(Announcer.class.getName());
    private final HaloHelper halo;
    private final SequentialBatchExecutor executor;

    Announcer(HaloHelper haloHelper, SequentialBatchExecutor anExecutor) {
        this.halo = haloHelper;
        this.executor = anExecutor;
    }

    @Override
    public final void close() {
        this.executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean announce(RegisterableService service, Duration ttl) throws IOException {
        LOGGER.fine(() -> "Start probing for " + service);
        ProbeListener listener = new ProbeListener(service);
        this.halo.addResponseListener(listener);
        ProbeTask probe = new ProbeTask(service, this.halo);
        String name = service.name();
        try {
            SequentialBatchExecutor.FutureBatch probes = this.executor.scheduleBatch(name, probe, HaloProperties.PROBE_NUM, HaloProperties.PROBING_INTERVAL);
            boolean conflictFree = !listener.await();
            probes.cancelAll();
            LOGGER.fine(() -> "Done probing for " + service + "; found conflicts? " + !conflictFree);
            if (conflictFree) {
                LOGGER.fine(() -> "Announcing " + service);
                AnnounceTask announce = new AnnounceTask(service, ttl, this.halo);
                this.executor.scheduleBatch(name, announce, HaloProperties.ANNOUNCEMENT_NUM, HaloProperties.ANNOUNCEMENT_INTERVAL).awaitFirst();
                LOGGER.info(() -> "Announced " + service);
            }
            boolean bl = conflictFree;
            return bl;
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "Interrupted while announcing service", e);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.halo.removeResponseListener(listener);
        }
    }

    final void reannounce(RegisteredService service, Duration ttl) throws IOException {
        try {
            LOGGER.fine(() -> "Re-announcing " + service);
            AnnounceTask announce = new AnnounceTask(service, ttl, this.halo);
            this.executor.scheduleBatch(service.name(), announce, HaloProperties.ANNOUNCEMENT_NUM, HaloProperties.ANNOUNCEMENT_INTERVAL).awaitFirst();
            LOGGER.info(() -> "Re-announced " + service);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "Interrupted while re-announcing service", e);
            Thread.currentThread().interrupt();
        }
    }

    private static final class ProbeTask
    implements Callable<Void> {
        private final RegisterableService service;
        private final HaloHelper halo;

        ProbeTask(RegisterableService aService, HaloHelper haloHelper) {
            this.service = aService;
            this.halo = haloHelper;
        }

        @Override
        public final Void call() throws Exception {
            Instant now = this.halo.now();
            String hostname = this.service.hostname();
            String serviceName = this.service.name();
            DnsMessage.Builder builder = DnsMessage.query(new short[0]).addQuestion(new DnsQuestion(hostname, 255, 1)).addQuestion(new DnsQuestion(serviceName, 255, 1)).addAuthority(new SrvRecord(serviceName, 1, HaloProperties.TTL, now, this.service.port(), hostname));
            this.service.ipv4Address().ifPresent(a -> builder.addAuthority(new AddressRecord(hostname, 1, HaloProperties.TTL, now, (InetAddress)a)));
            this.service.ipv6Address().ifPresent(a -> builder.addAuthority(new AddressRecord(hostname, 1, HaloProperties.TTL, now, (InetAddress)a)));
            this.halo.sendMessage(builder.get());
            return null;
        }
    }

    private static final class ProbeListener
    implements ResponseListener {
        private final Condition cdt;
        private final Lock lock;
        private final AtomicBoolean match;
        private final RegisterableService service;
        private final Predicate<? super DnsRecord> conflicting;

        ProbeListener(RegisterableService aService) {
            this.service = aService;
            this.match = new AtomicBoolean(false);
            this.lock = new ReentrantLock();
            this.cdt = this.lock.newCondition();
            this.conflicting = other -> {
                if (other.type() == 33 && other.name().equalsIgnoreCase(this.service.name())) {
                    SrvRecord srvRecord = (SrvRecord)other;
                    return !srvRecord.server().equalsIgnoreCase(this.service.hostname());
                }
                return false;
            };
        }

        @Override
        public final void responseReceived(DnsMessage response, HaloHelper halo) {
            this.lock.lock();
            LOGGER.fine(() -> "Handling " + response);
            try {
                if (response.answers().stream().anyMatch(this.conflicting)) {
                    this.match.set(true);
                    LOGGER.info(() -> "Received response matching probed service: " + response);
                    this.cdt.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean await() {
            this.lock.lock();
            boolean signalled = false;
            try {
                Timeout timeout = Timeout.ofDuration(HaloProperties.PROBING_TIMEOUT);
                Duration remaining = timeout.remaining();
                while (!this.match.get() && !remaining.isZero()) {
                    signalled = this.cdt.await(remaining.toMillis(), TimeUnit.MILLISECONDS);
                    remaining = timeout.remaining();
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted while waiting for match", e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
            if (!signalled) {
                LOGGER.fine(() -> "No matching response received within " + HaloProperties.PROBING_TIMEOUT);
            }
            return this.match.get();
        }
    }

    private static final class AnnounceTask
    implements Callable<Void> {
        private final Service service;
        private final Duration ttl;
        private final HaloHelper halo;

        AnnounceTask(Service aService, Duration aTtl, HaloHelper haloHelper) {
            this.service = aService;
            this.ttl = aTtl;
            this.halo = haloHelper;
        }

        @Override
        public final Void call() throws Exception {
            Instant now = this.halo.now();
            String hostname = this.service.hostname();
            Attributes attributes = this.service.attributes();
            String serviceName = this.service.name();
            short unique = MulticastDnsSd.uniqueClass((short)1);
            Optional<Instant> stamp = Optional.empty();
            DnsMessage.Builder builder = DnsMessage.response(1024).addAnswer(new PtrRecord(this.service.registrationPointerName(), 1, this.ttl, now, serviceName), stamp).addAnswer(new SrvRecord(serviceName, unique, this.ttl, now, this.service.port(), hostname), stamp).addAnswer(new TxtRecord(serviceName, unique, this.ttl, now, attributes), stamp);
            this.service.ipv4Address().ifPresent(a -> builder.addAnswer(new AddressRecord(hostname, unique, this.ttl, now, (InetAddress)a), stamp));
            this.service.ipv6Address().ifPresent(a -> builder.addAnswer(new AddressRecord(hostname, unique, this.ttl, now, (InetAddress)a), stamp));
            this.halo.sendMessage(builder.get());
            return null;
        }
    }
}

