/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.AttributesImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public interface Attributes {
    public static Builder create() {
        return new Builder();
    }

    public static Attributes empty() {
        return Attributes.create().get();
    }

    public Set<String> keys();

    public Optional<ByteBuffer> value(String var1);

    public Optional<String> value(String var1, Charset var2);

    public static final class Builder
    implements Supplier<Attributes> {
        private final Map<String, Optional<ByteBuffer>> map = new HashMap<String, Optional<ByteBuffer>>();

        Builder() {
        }

        @Override
        public final Attributes get() {
            return new AttributesImpl(this.map);
        }

        public final Builder with(String key) {
            if (this.isValidKey(key)) {
                this.map.put(key, Optional.empty());
            }
            return this;
        }

        public final Builder with(String key, ByteBuffer value) {
            if (this.isValidKey(key)) {
                this.map.put(key, Optional.of(value));
            }
            return this;
        }

        public final Builder with(String key, String value, Charset charset) {
            ByteBuffer buffer = ByteBuffer.wrap(value.getBytes(charset));
            buffer.order(ByteOrder.BIG_ENDIAN);
            return this.with(key, buffer);
        }

        private boolean isValidKey(String key) {
            return !key.isEmpty() && !this.map.containsKey(key);
        }
    }
}

