/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.Attributes;
import io.omam.halo.AttributesImpl;
import io.omam.halo.MessageInputStream;
import io.omam.halo.MessageOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;

final class AttributesCodec {
    private AttributesCodec() {
    }

    static Attributes decode(MessageInputStream input, int length) {
        HashMap<String, Optional<ByteBuffer>> map = new HashMap<String, Optional<ByteBuffer>>();
        int readBytes = 0;
        while (readBytes < length) {
            Optional<Object> value;
            String key;
            int pairLength = input.readByte();
            byte[] bytes = input.readBytes(pairLength);
            int sep = AttributesCodec.separator(bytes);
            if (sep == -1) {
                key = new String(bytes, StandardCharsets.UTF_8);
                value = Optional.empty();
            } else {
                key = new String(AttributesCodec.subarray(bytes, 0, sep), StandardCharsets.UTF_8);
                value = Optional.of(AttributesCodec.value(bytes, sep));
            }
            if (!key.isEmpty() && !map.containsKey(key)) {
                map.put(key, value);
            }
            readBytes = readBytes + pairLength + 1;
        }
        return new AttributesImpl(map);
    }

    static void encode(Attributes attributes, MessageOutputStream output) {
        Set<String> keys = attributes.keys();
        for (String key : keys) {
            try (MessageOutputStream attos = new MessageOutputStream();){
                attos.writeString(key);
                Optional<ByteBuffer> value = attributes.value(key);
                if (value.isPresent()) {
                    attos.writeString("=");
                    byte[] bytes = new byte[value.get().remaining()];
                    value.get().get(bytes);
                    attos.writeAllBytes(bytes);
                }
                output.writeByte(attos.size());
                output.writeAllBytes(attos.toByteArray());
            }
        }
    }

    private static int separator(byte[] bytes) {
        for (int index = 0; index < bytes.length; ++index) {
            if (bytes[index] != 61) continue;
            return index;
        }
        return -1;
    }

    private static byte[] subarray(byte[] bytes, int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        byte[] arr = new byte[length];
        System.arraycopy(bytes, beginIndex, arr, 0, length);
        return arr;
    }

    private static ByteBuffer value(byte[] bytes, int sep) {
        int length = bytes.length - sep;
        if (length == 1) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(AttributesCodec.subarray(bytes, sep + 1, bytes.length));
    }
}

