/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.Attributes;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class AttributesImpl
implements Attributes {
    private final Map<String, Optional<ByteBuffer>> map;

    AttributesImpl(Map<String, Optional<ByteBuffer>> aMap) {
        Objects.requireNonNull(aMap);
        this.map = aMap;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributesImpl)) {
            return false;
        }
        AttributesImpl other = (AttributesImpl)obj;
        return this.map.equals(other.map);
    }

    public final int hashCode() {
        return Objects.hashCode(this.map);
    }

    @Override
    public final Set<String> keys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public final String toString() {
        return "[" + this.keys().stream().map(k -> k + "=" + this.value((String)k, StandardCharsets.UTF_8)).collect(Collectors.joining(";")) + "]";
    }

    @Override
    public final Optional<ByteBuffer> value(String key) {
        return this.map.getOrDefault(key, Optional.empty()).map(ByteBuffer::asReadOnlyBuffer);
    }

    @Override
    public final Optional<String> value(String key, Charset charset) {
        Optional<ByteBuffer> optBuffer = this.value(key);
        if (!optBuffer.isPresent()) {
            return Optional.empty();
        }
        ByteBuffer buffer = optBuffer.get();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return Optional.of(new String(bytes, charset));
    }
}

