/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.DnsRecord;
import io.omam.halo.HaloProperties;
import io.omam.halo.MulticastDnsSd;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

final class Cache {
    private static final Logger LOGGER = Logger.getLogger(Cache.class.getName());
    private final Map<String, Collection<DnsRecord>> map = new ConcurrentHashMap<String, Collection<DnsRecord>>();

    Cache() {
    }

    private static boolean isSameClass(DnsRecord record1, DnsRecord record2) {
        return Cache.isSameClass(record1, record2.clazz());
    }

    private static boolean isSameClass(DnsRecord record, short clazz) {
        return record.clazz() == 255 || clazz == 255 || record.clazz() == clazz;
    }

    private static boolean isSameType(DnsRecord record1, DnsRecord record2) {
        return Cache.isSameType(record1, record2.type());
    }

    private static boolean isSameType(DnsRecord record, short type) {
        return record.type() == 255 || type == 255 || record.type() == type;
    }

    private static String key(DnsRecord record) {
        return MulticastDnsSd.toLowerCase(record.name());
    }

    private static void logResult(Optional<? extends DnsRecord> result) {
        if (result.isPresent()) {
            LOGGER.fine(() -> "Found cached " + result.get());
        } else {
            LOGGER.fine(() -> "No cached record found");
        }
    }

    private static boolean matches(DnsRecord record1, DnsRecord record2) {
        return Cache.isSameType(record1, record2) && Cache.isSameClass(record1, record2);
    }

    final void add(DnsRecord record) {
        Objects.requireNonNull(record);
        boolean existed = this.entries(record.name()).removeIf(other -> Cache.matches(other, record));
        String key = Cache.key(record);
        if (existed) {
            LOGGER.fine(() -> "Replacing cached record " + key + " with " + record);
        } else {
            LOGGER.fine(() -> "Adding " + record + " to cache");
        }
        this.map.computeIfAbsent(key, k -> new ConcurrentLinkedQueue()).add(record);
    }

    final void clean(Instant now) {
        HashSet<String> services = new HashSet<String>();
        for (Map.Entry<String, Collection<DnsRecord>> e : this.map.entrySet()) {
            e.getValue().removeIf(r -> r.isExpired(now));
            if (!e.getValue().isEmpty()) continue;
            services.add(e.getKey());
        }
        services.forEach(this.map::remove);
    }

    final void clear() {
        LOGGER.fine("Clearing cache");
        this.map.clear();
    }

    final Collection<DnsRecord> entries(String name) {
        return this.map.getOrDefault(MulticastDnsSd.toLowerCase(name), Collections.emptyList());
    }

    final void expire(DnsRecord record) {
        Objects.requireNonNull(record);
        this.entries(record.name()).stream().filter(other -> Cache.matches(record, other)).forEach(r -> {
            LOGGER.fine(() -> "Setting TTL of " + record + " to " + HaloProperties.EXPIRY_TTL);
            r.setTtl(HaloProperties.EXPIRY_TTL);
        });
    }

    final Optional<DnsRecord> get(String name, short type, short clazz) {
        LOGGER.fine(() -> "Searching cache for DNS record matching [Name=" + name + "; type=" + type + "; class=" + clazz + "]");
        Optional<DnsRecord> result = this.entries(name).stream().filter(r -> Cache.isSameType(r, type) && Cache.isSameClass(r, clazz)).findFirst();
        Cache.logResult(result);
        return result;
    }

    final void removeAll(String name) {
        Objects.requireNonNull(name);
        LOGGER.fine(() -> "Removing all DNS records associated with " + name + " from cache");
        this.map.remove(MulticastDnsSd.toLowerCase(name));
    }
}

