/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.AddressRecord;
import io.omam.halo.Attributes;
import io.omam.halo.DnsMessage;
import io.omam.halo.HaloHelper;
import io.omam.halo.HaloProperties;
import io.omam.halo.MulticastDnsSd;
import io.omam.halo.PtrRecord;
import io.omam.halo.SequentialBatchExecutor;
import io.omam.halo.Service;
import io.omam.halo.SrvRecord;
import io.omam.halo.TxtRecord;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Canceller
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(Canceller.class.getName());
    private final HaloHelper halo;
    private final SequentialBatchExecutor executor;

    Canceller(HaloHelper haloHelper, SequentialBatchExecutor anExecutor) {
        this.halo = haloHelper;
        this.executor = anExecutor;
    }

    @Override
    public final void close() {
        this.executor.shutdownNow();
    }

    final void cancel(Service service) throws IOException {
        LOGGER.fine(() -> "Cancelling " + service);
        try {
            CancelTask task = new CancelTask(service, this.halo);
            this.executor.scheduleBatch(service.name(), task, HaloProperties.CANCEL_NUM, HaloProperties.CANCELLING_INTERVAL).awaitFirst();
            LOGGER.info(() -> "Cancelled " + service);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "Interrupted while cancelling service", e);
            Thread.currentThread().interrupt();
        }
    }

    private static final class CancelTask
    implements Callable<Void> {
        private final Service service;
        private final HaloHelper halo;

        CancelTask(Service aService, HaloHelper haloHelper) {
            this.service = aService;
            this.halo = haloHelper;
        }

        @Override
        public final Void call() throws Exception {
            Instant now = this.halo.now();
            String hostname = this.service.hostname();
            Attributes attributes = this.service.attributes();
            String serviceName = this.service.name();
            short unique = MulticastDnsSd.uniqueClass((short)1);
            DnsMessage.Builder builder = DnsMessage.response(1024).addAnswer(new PtrRecord(this.service.registrationPointerName(), 1, Duration.ZERO, now, serviceName), Optional.empty()).addAnswer(new SrvRecord(serviceName, unique, Duration.ZERO, now, this.service.port(), hostname), Optional.empty()).addAnswer(new TxtRecord(serviceName, unique, Duration.ZERO, now, attributes), Optional.empty());
            this.service.ipv4Address().ifPresent(a -> builder.addAnswer(new AddressRecord(hostname, unique, Duration.ZERO, now, (InetAddress)a), Optional.empty()));
            this.service.ipv6Address().ifPresent(a -> builder.addAnswer(new AddressRecord(hostname, unique, Duration.ZERO, now, (InetAddress)a), Optional.empty()));
            this.halo.sendMessage(builder.get());
            return null;
        }
    }
}

