/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.AddressRecord;
import io.omam.halo.AttributesCodec;
import io.omam.halo.DnsQuestion;
import io.omam.halo.DnsRecord;
import io.omam.halo.MessageInputStream;
import io.omam.halo.MessageOutputStream;
import io.omam.halo.MulticastDnsSd;
import io.omam.halo.PtrRecord;
import io.omam.halo.SrvRecord;
import io.omam.halo.TxtRecord;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DnsMessage {
    private final List<DnsAnswer> answers = new ArrayList<DnsAnswer>();
    private final short flags;
    private final int nbAnswers;
    private final int nbAuthorities;
    private final int nbAdditional;
    private final List<DnsQuestion> questions;

    private DnsMessage(short someFlags, List<DnsQuestion> someQuestions, List<DnsAnswer> someAnswers, List<DnsRecord> someAuthorities, List<DnsRecord> someAdditional) {
        this.answers.addAll(someAnswers);
        someAuthorities.forEach(a -> this.answers.add(DnsAnswer.unstamped(a)));
        someAdditional.forEach(a -> this.answers.add(DnsAnswer.unstamped(a)));
        this.flags = someFlags;
        this.nbAnswers = someAnswers.size();
        this.nbAuthorities = someAuthorities.size();
        this.nbAdditional = someAdditional.size();
        this.questions = someQuestions;
    }

    static DnsMessage decode(byte[] bytes, Instant now) throws IOException {
        MessageInputStream input = new MessageInputStream(bytes);
        try {
            input.readShort();
            short flags = (short)input.readShort();
            int numQuestions = input.readShort();
            short numAnswers = (short)input.readShort();
            short numAuthorities = (short)input.readShort();
            short numAdditional = (short)input.readShort();
            ArrayList<DnsQuestion> questions = new ArrayList<DnsQuestion>();
            for (int i = 0; i < numQuestions; ++i) {
                String name = input.readName();
                short type = (short)input.readShort();
                short clazz = (short)input.readShort();
                DnsQuestion question = new DnsQuestion(name, type, clazz);
                questions.add(question);
            }
            List<DnsAnswer> answers = DnsMessage.readRecords(input, numAnswers, now).stream().map(DnsAnswer::unstamped).collect(Collectors.toList());
            List<DnsRecord> authorities = DnsMessage.readRecords(input, numAuthorities, now);
            List<DnsRecord> additional = DnsMessage.readRecords(input, numAdditional, now);
            DnsMessage dnsMessage = new DnsMessage(flags, questions, answers, authorities, additional);
            input.close();
            return dnsMessage;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BufferUnderflowException e) {
                throw new IOException(e);
            }
        }
    }

    static Builder query(short ... flags) {
        return new Builder(0, flags);
    }

    static Builder response(short ... flags) {
        return new Builder(Short.MIN_VALUE, flags);
    }

    private static Optional<DnsRecord> readRecord(MessageInputStream input, Instant now) throws IOException {
        DnsRecord record;
        String name = input.readName();
        short type = (short)input.readShort();
        short clazz = (short)input.readShort();
        Duration ttl = Duration.ofSeconds(input.readInt());
        short length = (short)input.readShort();
        switch (type) {
            case 1: {
                record = new AddressRecord(name, clazz, ttl, now, InetAddress.getByAddress(input.readBytes(length)));
                break;
            }
            case 28: {
                record = new AddressRecord(name, clazz, ttl, now, InetAddress.getByAddress(input.readBytes(length)));
                break;
            }
            case 12: {
                record = new PtrRecord(name, clazz, ttl, now, input.readName());
                break;
            }
            case 33: {
                input.readShort();
                input.readShort();
                short port = (short)input.readShort();
                String server = input.readName();
                record = new SrvRecord(name, clazz, ttl, now, port, server);
                break;
            }
            case 16: {
                record = new TxtRecord(name, clazz, ttl, now, AttributesCodec.decode(input, length));
                break;
            }
            default: {
                long skipped = input.skip(length);
                if (skipped != (long)length) {
                    throw new IOException("Failed to skip over ignored record.");
                }
                record = null;
            }
        }
        return Optional.ofNullable(record);
    }

    private static List<DnsRecord> readRecords(MessageInputStream input, int size, Instant now) throws IOException {
        ArrayList<DnsRecord> records = new ArrayList<DnsRecord>();
        for (int i = 0; i < size; ++i) {
            DnsMessage.readRecord(input, now).ifPresent(records::add);
        }
        return records;
    }

    private static void write(DnsQuestion question, MessageOutputStream mos) {
        mos.writeName(question.name());
        mos.writeShort(question.type());
        mos.writeShort(MulticastDnsSd.encodeClass(question.clazz(), question.isUnique()));
    }

    private static void write(DnsRecord record, Optional<Instant> stamp, MessageOutputStream mos) {
        mos.writeName(record.name());
        mos.writeShort(record.type());
        mos.writeShort(MulticastDnsSd.encodeClass(record.clazz(), record.isUnique()));
        if (stamp.isPresent()) {
            mos.writeInt((int)record.remainingTtl(stamp.get()).getSeconds());
        } else {
            mos.writeInt((int)record.ttl().getSeconds());
        }
        int sizePos = mos.position();
        mos.skip(2);
        int startPos = mos.position();
        record.write(mos);
        int endPos = mos.position();
        mos.writeShort(sizePos, (short)(endPos - startPos));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder("DNS ");
        if (this.isQuery()) {
            builder.append("query with ").append(this.questions.size()).append(" question(s): ").append(this.questions.toString());
        } else {
            builder.append("response with ").append(this.answers.size()).append(" answer(s): ").append(this.answers.toString());
        }
        return builder.toString();
    }

    final List<DnsRecord> answers() {
        return Collections.unmodifiableList(this.answers.stream().map(DnsAnswer::record).collect(Collectors.toList()));
    }

    final byte[] encode() {
        try (MessageOutputStream output = new MessageOutputStream();){
            output.writeShort(0);
            output.writeShort(this.flags);
            output.writeShort((short)this.questions.size());
            output.writeShort((short)this.nbAnswers);
            output.writeShort((short)this.nbAuthorities);
            output.writeShort((short)this.nbAdditional);
            this.questions.forEach(q -> DnsMessage.write(q, output));
            this.answers.forEach(a -> DnsMessage.write(a.record(), a.stamp(), output));
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    final short flags() {
        return this.flags;
    }

    final boolean isQuery() {
        return (this.flags & Short.MIN_VALUE) == 0;
    }

    final boolean isResponse() {
        return (this.flags & Short.MIN_VALUE) == Short.MIN_VALUE;
    }

    final List<DnsQuestion> questions() {
        return Collections.unmodifiableList(this.questions);
    }

    private static final class DnsAnswer {
        private final DnsRecord record;
        private final Optional<Instant> stamp;

        private DnsAnswer(DnsRecord aRecord, Optional<Instant> aStamp) {
            this.stamp = aStamp;
            this.record = aRecord;
        }

        static DnsAnswer stamped(DnsRecord record, Instant stamp) {
            return new DnsAnswer(record, Optional.of(stamp));
        }

        static DnsAnswer unstamped(DnsRecord record) {
            return new DnsAnswer(record, Optional.empty());
        }

        public final String toString() {
            return this.record.toString();
        }

        final DnsRecord record() {
            return this.record;
        }

        final Optional<Instant> stamp() {
            return this.stamp;
        }
    }

    static final class Builder
    implements Supplier<DnsMessage> {
        private final short flags;
        private final List<DnsQuestion> questions;
        private final List<DnsAnswer> answers;
        private final List<DnsRecord> authorities;
        private final List<DnsRecord> additional;

        private Builder(short flag, short[] otherFlags) {
            short someFlags = flag;
            for (short of : otherFlags) {
                someFlags = (short)(someFlags | of);
            }
            this.flags = someFlags;
            this.questions = new ArrayList<DnsQuestion>();
            this.answers = new ArrayList<DnsAnswer>();
            this.authorities = new ArrayList<DnsRecord>();
            this.additional = new ArrayList<DnsRecord>();
        }

        @Override
        public final DnsMessage get() {
            return new DnsMessage(this.flags, this.questions, this.answers, this.authorities, this.additional);
        }

        final Builder addAdditional(DnsRecord record) {
            this.additional.add(record);
            return this;
        }

        final Builder addAnswer(DnsMessage msg, DnsRecord answer) {
            if (msg == null || !answer.suppressedBy(msg)) {
                this.answers.add(DnsAnswer.unstamped(answer));
            }
            return this;
        }

        final Builder addAnswer(DnsRecord answer, Optional<Instant> stamp) {
            if (stamp.isPresent()) {
                if (!answer.isExpired(stamp.get())) {
                    this.answers.add(DnsAnswer.stamped(answer, stamp.get()));
                }
            } else {
                this.answers.add(DnsAnswer.unstamped(answer));
            }
            return this;
        }

        final Builder addAuthority(DnsRecord authority) {
            this.authorities.add(authority);
            return this;
        }

        final Builder addQuestion(DnsQuestion question) {
            this.questions.add(question);
            return this;
        }
    }
}

