/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.DnsEntry;
import io.omam.halo.DnsMessage;
import io.omam.halo.MessageOutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

abstract class DnsRecord
extends DnsEntry {
    private Duration ttl;
    private final Instant ioc;

    protected DnsRecord(String aName, short aType, short aClass, Duration aTtl, Instant now) {
        super(aName, aType, aClass);
        Objects.requireNonNull(aTtl);
        Objects.requireNonNull(now);
        this.ttl = aTtl;
        this.ioc = now;
    }

    protected abstract void write(MessageOutputStream var1);

    final Instant expirationTime(int percent) {
        long ttlPercent = (long)((double)this.ttl.toNanos() * ((double)percent / 100.0));
        return this.ioc.plus(Duration.ofNanos(ttlPercent));
    }

    final boolean isExpired(Instant now) {
        Instant instant = this.expirationTime(100);
        return instant.equals(now) || instant.isBefore(now);
    }

    final Duration remainingTtl(Instant now) {
        Duration dur = Duration.between(now, this.expirationTime(100));
        if (dur.isNegative()) {
            return Duration.ZERO;
        }
        return dur;
    }

    final void setTtl(Duration aTtl) {
        this.ttl = aTtl;
    }

    final boolean suppressedBy(DnsMessage msg) {
        return msg.answers().stream().anyMatch(this::suppressedBy);
    }

    final boolean suppressedBy(DnsRecord other) {
        return this.name().equals(other.name()) && this.type() == other.type() && this.clazz() == other.clazz() && other.ttl.compareTo(this.ttl.dividedBy(2L)) >= 0;
    }

    final Duration ttl() {
        return this.ttl;
    }
}

