/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.Browser;
import io.omam.halo.HaloImpl;
import io.omam.halo.HaloProperties;
import io.omam.halo.RegisterableService;
import io.omam.halo.RegisteredService;
import io.omam.halo.RegistrationTypeBrowserListener;
import io.omam.halo.ResolvedService;
import io.omam.halo.ServiceBrowserListener;
import java.io.IOException;
import java.net.NetworkInterface;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;

public interface Halo
extends AutoCloseable {
    public static Halo allNetworkInterfaces(Clock clock) throws IOException {
        return new HaloImpl(clock, Collections.emptyList());
    }

    public static Halo networkInterfaces(Clock clock, NetworkInterface nic, NetworkInterface ... nics) throws IOException {
        ArrayList<NetworkInterface> allNics = new ArrayList<NetworkInterface>();
        allNics.add(nic);
        for (NetworkInterface n : nics) {
            allNics.add(n);
        }
        return new HaloImpl(clock, allNics);
    }

    public Browser browse(RegistrationTypeBrowserListener var1);

    public Browser browse(String var1, ServiceBrowserListener var2);

    @Override
    public void close();

    public void deregister(RegisteredService var1) throws IOException;

    public void deregisterAll() throws IOException;

    default public RegisteredService register(RegisterableService service) throws IOException {
        return this.register(service, true);
    }

    default public RegisteredService register(RegisterableService service, boolean allowNameChange) throws IOException {
        return this.register(service, HaloProperties.TTL, allowNameChange);
    }

    public RegisteredService register(RegisterableService var1, Duration var2, boolean var3) throws IOException;

    public void resetBrowsingInterval();

    default public Optional<ResolvedService> resolve(String instanceName, String registrationType) {
        return this.resolve(instanceName, registrationType, HaloProperties.RESOLUTION_TIMEOUT);
    }

    public Optional<ResolvedService> resolve(String var1, String var2, Duration var3);
}

