/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.HaloHelper;
import io.omam.halo.HaloProperties;
import io.omam.halo.IncreasingRateExecutor;
import io.omam.halo.ResponseListener;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

abstract class HaloBrowser
implements ResponseListener,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(HaloBrowser.class.getName());
    private final HaloHelper halo;
    private final String name;
    private final IncreasingRateExecutor ses;
    private IncreasingRateExecutor.IncreasingRateTask task;

    HaloBrowser(String aName, HaloHelper haloHelper) {
        this.name = aName;
        this.halo = haloHelper;
        this.ses = new IncreasingRateExecutor(aName);
        this.task = null;
    }

    @Override
    public final void close() {
        this.halo.removeResponseListener(this);
        if (this.task != null) {
            this.task.cancel();
        }
        this.ses.shutdownNow();
        this.doClose();
    }

    final void resetQueryInterval() {
        if (this.task != null) {
            LOGGER.info(() -> "Reset browsing interval for " + this.name + " to ");
            this.task.reset();
        }
    }

    final void start() {
        if (this.task == null) {
            this.halo.addResponseListener(this);
            this.task = this.ses.scheduleIncreasingly(this.queryTask(), HaloProperties.QUERYING_FIRST, HaloProperties.QUERYING_DELAY, HaloProperties.QUERYING_INCREASE, HaloProperties.QUERYING_MAX);
        }
    }

    protected abstract void doClose();

    protected abstract Callable<Void> queryTask();
}

