/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Properties;

public final class HaloProperties {
    public static final InetAddress IPV4_ADDR;
    public static final InetAddress IPV6_ADDR;
    public static final int MDNS_PORT;
    public static final InetSocketAddress IPV4_SOA;
    public static final InetSocketAddress IPV6_SOA;
    public static final Duration PROBING_INTERVAL;
    public static final Duration PROBING_TIMEOUT;
    public static final int PROBE_NUM;
    public static final Duration ANNOUNCEMENT_INTERVAL;
    public static final int ANNOUNCEMENT_NUM;
    public static final Duration CANCELLING_INTERVAL;
    public static final int CANCEL_NUM;
    public static final Duration REAPING_INTERVAL;
    public static final Duration RESOLUTION_TIMEOUT;
    public static final Duration RESOLUTION_INTERVAL;
    public static final Duration QUERYING_FIRST;
    public static final Duration QUERYING_DELAY;
    public static final int QUERYING_INCREASE;
    public static final Duration QUERYING_MAX;
    public static final Duration TTL;
    public static final Duration EXPIRY_TTL;

    private HaloProperties() {
    }

    private static Duration durationProp(String key, Properties props) {
        return Duration.ofMillis(Long.parseLong(HaloProperties.stringProp(key, props)));
    }

    private static int intProp(String key, Properties props) {
        return Integer.parseInt(HaloProperties.stringProp(key, props));
    }

    private static String stringProp(String key, Properties props) {
        return System.getProperty(key, props.getProperty(key));
    }

    static {
        try (InputStream input = HaloProperties.class.getClassLoader().getResourceAsStream("halo.properties");){
            Properties props = new Properties();
            props.load(input);
            IPV4_ADDR = InetAddress.getByName(HaloProperties.stringProp("io.omam.halo.mdns.ipv4", props));
            IPV6_ADDR = InetAddress.getByName(HaloProperties.stringProp("io.omam.halo.mdns.ipv6", props));
            MDNS_PORT = HaloProperties.intProp("io.omam.halo.mdns.port", props);
            IPV4_SOA = new InetSocketAddress(IPV4_ADDR, MDNS_PORT);
            IPV6_SOA = new InetSocketAddress(IPV6_ADDR, MDNS_PORT);
            RESOLUTION_TIMEOUT = HaloProperties.durationProp("io.omam.halo.resolution.timeout", props);
            RESOLUTION_INTERVAL = HaloProperties.durationProp("io.omam.halo.resolution.interval", props);
            PROBING_TIMEOUT = HaloProperties.durationProp("io.omam.halo.probing.timeout", props);
            PROBING_INTERVAL = HaloProperties.durationProp("io.omam.halo.probing.interval", props);
            PROBE_NUM = Math.max(1, HaloProperties.intProp("io.omam.halo.probing.number", props));
            ANNOUNCEMENT_INTERVAL = HaloProperties.durationProp("io.omam.halo.announcement.interval", props);
            ANNOUNCEMENT_NUM = Math.max(1, HaloProperties.intProp("io.omam.halo.announcement.number", props));
            QUERYING_FIRST = HaloProperties.durationProp("io.omam.halo.querying.first", props);
            QUERYING_DELAY = HaloProperties.durationProp("io.omam.halo.querying.delay", props);
            QUERYING_INCREASE = HaloProperties.intProp("io.omam.halo.querying.increase", props);
            QUERYING_MAX = HaloProperties.durationProp("io.omam.halo.querying.max", props);
            CANCELLING_INTERVAL = HaloProperties.durationProp("io.omam.halo.cancellation.interval", props);
            CANCEL_NUM = Math.max(1, HaloProperties.intProp("io.omam.halo.cancellation.number", props));
            REAPING_INTERVAL = HaloProperties.durationProp("io.omam.halo.reaper.interval", props);
            TTL = HaloProperties.durationProp("io.omam.halo.ttl.default", props);
            EXPIRY_TTL = HaloProperties.durationProp("io.omam.halo.ttl.expiry", props);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

