/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.DnsMessage;
import io.omam.halo.DnsQuestion;
import io.omam.halo.HaloBrowser;
import io.omam.halo.HaloHelper;
import io.omam.halo.PtrRecord;
import io.omam.halo.RegistrationTypeBrowserListener;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;

final class HaloRegistrationTypeBrowser
extends HaloBrowser {
    private static final Logger LOGGER = Logger.getLogger(HaloRegistrationTypeBrowser.class.getName());
    private final HaloHelper halo;
    private final Collection<RegistrationTypeBrowserListener> listeners;
    private final Collection<String> rts;

    HaloRegistrationTypeBrowser(HaloHelper haloHelper) {
        super("registration-discoverer", haloHelper);
        this.halo = haloHelper;
        this.listeners = new ConcurrentLinkedQueue<RegistrationTypeBrowserListener>();
        this.rts = new ConcurrentLinkedQueue<String>();
    }

    @Override
    public final void responseReceived(DnsMessage response, HaloHelper haloHelper) {
        LOGGER.fine(() -> "Handling " + response);
        response.answers().stream().filter(r -> r.type() == 12 && r.name().equalsIgnoreCase("_services._dns-sd._udp.local.")).map(r -> (PtrRecord)r).forEach(this::handlePointer);
    }

    final void addListener(RegistrationTypeBrowserListener listener) {
        Objects.requireNonNull(listener);
        this.rts.forEach(listener::registrationTypeAdded);
        this.listeners.add(listener);
    }

    final void removeListener(RegistrationTypeBrowserListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @Override
    protected final void doClose() {
    }

    @Override
    protected final Callable<Void> queryTask() {
        return new QueryTask();
    }

    private void handlePointer(PtrRecord record) {
        int end = record.target().indexOf("local");
        if (end == -1) {
            LOGGER.warning(() -> "Ignored pointer to [" + record.target() + "]");
        } else {
            String regType = record.target().substring(0, end);
            if (!this.rts.contains(regType)) {
                LOGGER.info(() -> "Discovered new registration type [" + record.target() + "]");
                this.rts.add(regType);
                this.listeners.forEach(l -> l.registrationTypeAdded(regType));
            }
        }
    }

    private final class QueryTask
    implements Callable<Void> {
        QueryTask() {
        }

        @Override
        public final Void call() {
            DnsMessage.Builder builder = DnsMessage.query(new short[0]).addQuestion(new DnsQuestion("_services._dns-sd._udp.local.", 12, 1));
            HaloRegistrationTypeBrowser.this.halo.sendMessage(builder.get());
            return null;
        }
    }
}

