/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.DnsMessage;
import io.omam.halo.DnsQuestion;
import io.omam.halo.HaloBrowser;
import io.omam.halo.HaloHelper;
import io.omam.halo.HaloProperties;
import io.omam.halo.HaloThreadFactory;
import io.omam.halo.MulticastDnsSd;
import io.omam.halo.PtrRecord;
import io.omam.halo.ResolvableService;
import io.omam.halo.ServiceBrowserListener;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class HaloServiceBrowser
extends HaloBrowser {
    private static final Logger LOGGER = Logger.getLogger(HaloServiceBrowser.class.getName());
    private final HaloHelper halo;
    private final Map<String, Collection<ServiceBrowserListener>> listeners;
    private final Map<String, Map<String, ResolvableService>> services;
    private final ExecutorService executor;

    HaloServiceBrowser(HaloHelper haloHelper) {
        super("service-discoverer", haloHelper);
        this.halo = haloHelper;
        this.listeners = new ConcurrentHashMap<String, Collection<ServiceBrowserListener>>();
        this.services = new ConcurrentHashMap<String, Map<String, ResolvableService>>();
        this.executor = Executors.newSingleThreadExecutor(new HaloThreadFactory("service-resolver"));
    }

    private static String toRpn(String registrationType) {
        return MulticastDnsSd.toLowerCase(registrationType + "local" + ".");
    }

    @Override
    public final void responseReceived(DnsMessage response, HaloHelper haloHelper) {
        this.pointers(response).forEach((rpn, ptr) -> this.executor.execute(() -> this.handleResponse((String)rpn, (Collection<PtrRecord>)ptr)));
    }

    final void addListener(String registrationType, ServiceBrowserListener listener) {
        Objects.requireNonNull(registrationType);
        Objects.requireNonNull(listener);
        String rpn = HaloServiceBrowser.toRpn(registrationType);
        Collection rls = this.listeners.computeIfAbsent(rpn, k -> new ConcurrentLinkedQueue());
        Map resolved = this.services.computeIfAbsent(rpn, k -> new ConcurrentHashMap());
        resolved.values().forEach(listener::serviceAdded);
        rls.add(listener);
    }

    final void removeListener(String registrationType, ServiceBrowserListener listener) {
        Objects.requireNonNull(registrationType);
        Objects.requireNonNull(listener);
        String rpn = HaloServiceBrowser.toRpn(registrationType);
        Collection<ServiceBrowserListener> rls = this.listeners.get(rpn);
        if (rls == null) {
            LOGGER.warning(() -> registrationType + " is not being browsed.");
        } else if (rls.size() == 1) {
            this.listeners.remove(rpn);
        } else {
            rls.remove(listener);
        }
    }

    @Override
    protected final void doClose() {
        this.executor.shutdownNow();
    }

    @Override
    protected final Callable<Void> queryTask() {
        return new QueryTask();
    }

    private void handlePtrExpiry(Map<String, ResolvableService> rservices, Collection<ServiceBrowserListener> rlisteners, String serviceName) {
        String skey = MulticastDnsSd.toLowerCase(serviceName);
        ResolvableService service = rservices.remove(skey);
        if (service != null) {
            LOGGER.info(() -> "Service [" + serviceName + "] has been removed");
            rlisteners.forEach(l -> l.serviceRemoved(service));
        }
    }

    private void handleResponse(String rpn, Collection<PtrRecord> pointers) {
        Map<String, ResolvableService> rservices = this.services.get(rpn);
        Collection<ServiceBrowserListener> rlisteners = this.listeners.get(rpn);
        Instant now = this.halo.now();
        for (PtrRecord ptr : pointers) {
            String serviceName = ptr.target();
            if (ptr.isExpired(now)) {
                this.handlePtrExpiry(rservices, rlisteners, serviceName);
                continue;
            }
            this.submitResolution(rpn, serviceName);
        }
    }

    private Map<String, List<PtrRecord>> pointers(DnsMessage response) {
        Set<String> rpns = this.listeners.keySet();
        return response.answers().stream().filter(r -> r.type() == 12 && rpns.contains(MulticastDnsSd.toLowerCase(r.name()))).map(r -> (PtrRecord)r).collect(Collectors.groupingBy(r -> MulticastDnsSd.toLowerCase(r.name())));
    }

    private void submitResolution(String rpn, String serviceName) {
        Optional<String> instanceName = ResolvableService.instanceNameOf(serviceName);
        Optional<String> registrationType = ResolvableService.registrationTypeOf(serviceName);
        if (instanceName.isPresent() && registrationType.isPresent()) {
            LOGGER.fine(() -> "Discovered [" + serviceName + "]");
            ResolvableService service = new ResolvableService(instanceName.get(), registrationType.get());
            this.executor.execute(new ResolveTask(rpn, service));
        } else {
            LOGGER.warning(() -> "Could not decode service name [" + serviceName + "]");
        }
    }

    private final class ResolveTask
    implements Runnable {
        private final String rpn;
        private final ResolvableService service;

        ResolveTask(String registrationPointerName, ResolvableService aService) {
            this.rpn = registrationPointerName;
            this.service = aService;
        }

        @Override
        public final void run() {
            try {
                boolean resolved = this.service.resolve(HaloServiceBrowser.this.halo, HaloProperties.RESOLUTION_TIMEOUT);
                if (resolved) {
                    if (this.alreadyResolved()) {
                        LOGGER.fine(() -> "Ignoring already resolved " + this.service + " attributes: " + this.service.attributes());
                    } else {
                        String skey = MulticastDnsSd.toLowerCase(this.service.name());
                        boolean added = ((Map)HaloServiceBrowser.this.services.get(this.rpn)).get(skey) == null;
                        ((Map)HaloServiceBrowser.this.services.get(this.rpn)).put(skey, this.service);
                        Collection rlisteners = (Collection)HaloServiceBrowser.this.listeners.get(this.rpn);
                        if (added) {
                            LOGGER.info(() -> "Resolved (added) " + this.service);
                            rlisteners.forEach(l -> l.serviceAdded(this.service));
                        } else {
                            LOGGER.info(() -> "Resolved (updated) " + this.service);
                            rlisteners.forEach(l -> l.serviceUpdated(this.service));
                        }
                    }
                } else {
                    LOGGER.warning(() -> "Could not resolve " + this.service);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted while waiting for response", e);
                Thread.currentThread().interrupt();
            }
        }

        private boolean alreadyResolved() {
            String skey = MulticastDnsSd.toLowerCase(this.service.name());
            ResolvableService existing = (ResolvableService)((Map)HaloServiceBrowser.this.services.get(this.rpn)).get(skey);
            if (existing == null) {
                return false;
            }
            return this.service.hostname().equals(existing.hostname()) && this.service.ipv4Address().equals(existing.ipv4Address()) && this.service.ipv6Address().equals(existing.ipv6Address()) && this.service.port() == existing.port() && this.service.attributes().equals(existing.attributes());
        }
    }

    private final class QueryTask
    implements Callable<Void> {
        QueryTask() {
        }

        @Override
        public final Void call() {
            Set rpns = HaloServiceBrowser.this.listeners.keySet();
            DnsMessage.Builder builder = DnsMessage.query(new short[0]);
            for (String rpn : rpns) {
                builder.addQuestion(new DnsQuestion(rpn, 12, 1));
            }
            HaloServiceBrowser.this.halo.sendMessage(builder.get());
            return null;
        }
    }
}

