/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class HaloThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    HaloThreadFactory(String suffix) {
        this.namePrefix = "halo-" + suffix + "-" + POOL_NUMBER.getAndIncrement() + "-thread-";
    }

    @Override
    public final Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
        thread.setDaemon(true);
        thread.setPriority(5);
        return thread;
    }
}

