/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.HaloThreadFactory;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

final class IncreasingRateExecutor {
    private final ScheduledExecutorService ses;

    IncreasingRateExecutor(String name) {
        this.ses = Executors.newSingleThreadScheduledExecutor(new HaloThreadFactory(name));
    }

    final IncreasingRateTask scheduleIncreasingly(Callable<Void> task, Duration initialDelay, Duration baseDelay, int increaseFactor, Duration maxDelay) {
        IncreasingRateCallable callable = new IncreasingRateCallable(task, this.ses, baseDelay, increaseFactor, maxDelay);
        ScheduledFuture<Void> future = this.ses.schedule(callable, initialDelay.toMillis(), TimeUnit.MILLISECONDS);
        return new IncreasingRateTask(callable, future);
    }

    final void shutdownNow() {
        this.ses.shutdownNow();
    }

    private static class IncreasingRateCallable
    implements Callable<Void> {
        private static final Logger LOGGER = Logger.getLogger(IncreasingRateCallable.class.getName());
        private final Callable<Void> task;
        private final ScheduledExecutorService executor;
        private final long initialDelay;
        private long currentDelay;
        private final int increaseFactor;
        private final long maxDelay;

        IncreasingRateCallable(Callable<Void> aTask, ScheduledExecutorService anExecutor, Duration anInitialDelay, int anIncreaseFactor, Duration aMaxDelay) {
            this.task = aTask;
            this.executor = anExecutor;
            this.currentDelay = this.initialDelay = anInitialDelay.toMillis();
            this.increaseFactor = anIncreaseFactor;
            this.maxDelay = aMaxDelay.toMillis();
        }

        @Override
        public final Void call() throws Exception {
            this.task.call();
            long delay = this.currentDelay;
            LOGGER.fine(() -> "Scheduling next task in " + Duration.ofMillis(delay));
            this.currentDelay = Math.min(this.maxDelay, this.currentDelay * (long)this.increaseFactor);
            this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
            return null;
        }

        final void reset() {
            this.currentDelay = this.initialDelay;
        }
    }

    static final class IncreasingRateTask {
        private final IncreasingRateCallable callable;
        private final Future<Void> future;

        IncreasingRateTask(IncreasingRateCallable aCallable, Future<Void> aFuture) {
            this.callable = aCallable;
            this.future = aFuture;
        }

        final void cancel() {
            this.future.cancel(true);
        }

        final void reset() {
            this.callable.reset();
        }
    }
}

