/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

final class MessageInputStream
extends ByteArrayInputStream {
    private final Map<Integer, String> pointers = new HashMap<Integer, String>();

    MessageInputStream(byte[] buffer) {
        super(buffer);
    }

    @Override
    public final void close() {
    }

    final int readByte() {
        return this.read();
    }

    final byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.read(bytes, 0, length);
        return bytes;
    }

    final int readInt() {
        return this.readShort() << 16 | this.readShort();
    }

    final String readName() {
        int read;
        HashMap<Integer, StringBuilder> names = new HashMap<Integer, StringBuilder>();
        StringBuilder name = new StringBuilder();
        boolean finished = false;
        while (!finished && (read = this.readByte()) != 0) {
            if ((read & 0xC0) == 0) {
                int offset = this.pos - 1;
                String label = this.readString(read) + ".";
                name.append(label);
                for (StringBuilder previousLabel : names.values()) {
                    previousLabel.append(label);
                }
                names.put(offset, new StringBuilder(label));
                continue;
            }
            int index = (read & 0x3F) << 8 | this.readByte();
            String compressedLabel = this.pointers.get(index);
            name.append(compressedLabel);
            for (StringBuilder previousLabel : names.values()) {
                previousLabel.append(compressedLabel);
            }
            finished = true;
        }
        for (Map.Entry entry : names.entrySet()) {
            Integer index = (Integer)entry.getKey();
            this.pointers.put(index, ((StringBuilder)entry.getValue()).toString());
        }
        return name.toString();
    }

    final int readShort() {
        return this.readByte() << 8 | this.readByte();
    }

    private String readString(int length) {
        byte[] bytes = this.readBytes(length);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

