/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

final class MessageOutputStream
extends ByteArrayOutputStream {
    private static final char DOT = '.';
    private final Map<String, Integer> pointers = new HashMap<String, Integer>();

    MessageOutputStream() {
    }

    @Override
    public final void close() {
    }

    final int position() {
        return this.count;
    }

    final void skip(int length) {
        this.count += length;
    }

    final void writeAllBytes(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    final void writeByte(int value) {
        this.write(value & 0xFF);
    }

    final void writeInt(int value) {
        this.writeShort(value >> 16);
        this.writeShort(value);
    }

    final void writeName(String name) {
        String sub = name;
        while (true) {
            int split;
            if ((split = sub.indexOf(46)) < 0) {
                split = sub.length();
            }
            if (split <= 0) {
                this.writeByte(0);
                return;
            }
            String label = sub.substring(0, split);
            Integer offset = this.pointers.get(sub);
            if (offset != null) {
                int val = offset;
                this.writeByte(val >> 8 | 0xC0);
                this.writeByte(val & 0xFF);
                return;
            }
            this.pointers.put(sub, this.size());
            this.writeCharacterString(label);
            if ((sub = sub.substring(split)).charAt(0) != '.') continue;
            sub = sub.substring(1);
        }
    }

    final void writeShort(int value) {
        this.writeByte(value >> 8);
        this.writeByte(value);
    }

    final void writeShort(int index, short value) {
        this.buf[index] = (byte)(value >> 8 & 0xFF);
        this.buf[index + 1] = (byte)(value & 0xFF);
    }

    final void writeString(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeAllBytes(bytes);
    }

    private void writeCharacterString(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeByte(bytes.length);
        this.writeAllBytes(bytes);
    }
}

