/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.Cache;
import io.omam.halo.HaloProperties;
import io.omam.halo.HaloThreadFactory;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class Reaper
implements AutoCloseable {
    private final Cache cache;
    private final Clock clock;
    private final ScheduledExecutorService ses;
    private Future<?> future;

    Reaper(Cache aCache, Clock aClock) {
        this.cache = aCache;
        this.clock = aClock;
        this.ses = Executors.newSingleThreadScheduledExecutor(new HaloThreadFactory("reaper"));
    }

    @Override
    public final void close() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        this.ses.shutdownNow();
    }

    final void start() {
        this.future = this.ses.scheduleAtFixedRate(() -> this.cache.clean(this.clock.instant()), HaloProperties.REAPING_INTERVAL.toMillis(), HaloProperties.REAPING_INTERVAL.toMillis(), TimeUnit.MILLISECONDS);
    }
}

