/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.Attributes;
import io.omam.halo.RegisterableServiceImpl;
import io.omam.halo.Service;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.function.Supplier;

public interface RegisterableService
extends Service {
    public static Builder create(String instanceName, String registrationType, int port) {
        return new Builder(instanceName, registrationType, port);
    }

    public static final class Builder
    implements Supplier<RegisterableService> {
        private static final InetAddress LOCAL_HOST;
        private final String instanceName;
        private final String registrationType;
        private String hostname;
        private Optional<InetAddress> ipv4Address;
        private Optional<InetAddress> ipv6Address;
        private final short port;
        private Attributes attributes;

        Builder(String anInstanceName, String aRegistrationType, int aPort) {
            this.instanceName = anInstanceName;
            this.registrationType = aRegistrationType;
            this.port = (short)aPort;
            this.hostname = LOCAL_HOST.getHostName();
            if (LOCAL_HOST instanceof Inet4Address) {
                this.ipv4Address = Optional.of((Inet4Address)LOCAL_HOST);
                this.ipv6Address = Optional.empty();
            } else if (LOCAL_HOST instanceof Inet6Address) {
                this.ipv4Address = Optional.empty();
                this.ipv6Address = Optional.of((Inet6Address)LOCAL_HOST);
            }
            this.attributes = Attributes.empty();
        }

        public final Builder attributes(Attributes someAttributes) {
            this.attributes = someAttributes;
            return this;
        }

        @Override
        public final RegisterableService get() {
            return new RegisterableServiceImpl(this.instanceName, this.registrationType, this.hostname, this.ipv4Address, this.ipv6Address, this.port, this.attributes);
        }

        public final Builder hostname(String aHostname) {
            this.hostname = aHostname;
            return this;
        }

        public final Builder ipv4Address(Inet4Address address) {
            this.ipv4Address = Optional.of(address);
            return this;
        }

        public final Builder ipv6Address(Inet6Address address) {
            this.ipv6Address = Optional.of(address);
            return this;
        }

        static {
            try {
                LOCAL_HOST = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

