/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.AddressRecord;
import io.omam.halo.Attributes;
import io.omam.halo.BaseService;
import io.omam.halo.DnsMessage;
import io.omam.halo.DnsQuestion;
import io.omam.halo.DnsRecord;
import io.omam.halo.HaloHelper;
import io.omam.halo.HaloProperties;
import io.omam.halo.ResolvedService;
import io.omam.halo.ResponseListener;
import io.omam.halo.SrvRecord;
import io.omam.halo.Timeout;
import io.omam.halo.TxtRecord;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

final class ResolvableService
extends BaseService
implements ResolvedService,
ResponseListener {
    private static final Logger LOGGER = Logger.getLogger(ResolvableService.class.getName());
    private static final String UPDATED_TO = "] updated to ";
    private Attributes attributes = null;
    private volatile boolean awaitingResolution = false;
    private String hostname = null;
    private Optional<InetAddress> ipv4Address = Optional.empty();
    private Optional<InetAddress> ipv6Address = Optional.empty();
    private final Lock lock;
    private short port = (short)-1;
    private final Condition resolved;

    ResolvableService(String anInstanceName, String aRegistrationType) {
        super(anInstanceName, aRegistrationType);
        this.lock = new ReentrantLock();
        this.resolved = this.lock.newCondition();
    }

    static Optional<String> instanceNameOf(String serviceName) {
        int end = serviceName.indexOf(46);
        return end == -1 ? Optional.empty() : Optional.of(serviceName.substring(0, end));
    }

    static Optional<String> registrationTypeOf(String serviceName) {
        int begin = serviceName.indexOf(46);
        int end = serviceName.indexOf("local");
        return begin == -1 || end == -1 ? Optional.empty() : Optional.of(serviceName.substring(begin + 1, end));
    }

    @Override
    public final Attributes attributes() {
        return this.attributes;
    }

    @Override
    public final String hostname() {
        return this.hostname;
    }

    @Override
    public final Optional<InetAddress> ipv4Address() {
        return this.ipv4Address;
    }

    @Override
    public final Optional<InetAddress> ipv6Address() {
        return this.ipv6Address;
    }

    @Override
    public final short port() {
        return this.port;
    }

    @Override
    public final void responseReceived(DnsMessage response, HaloHelper halo) {
        this.lock.lock();
        LOGGER.fine(() -> "Handling " + response);
        try {
            response.answers().forEach(a -> this.update(halo, (DnsRecord)a));
            boolean bl = this.awaitingResolution = !this.resolved();
            if (!this.awaitingResolution) {
                LOGGER.fine("Received response resolving service");
                this.resolved.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean resolve(HaloHelper halo, Duration timeout) throws InterruptedException {
        Optional<Object> cachedIpV6;
        Optional<Object> cachedIpV4;
        String serviceName = this.name();
        Optional<DnsRecord> cachedSrv = halo.cachedRecord(serviceName, (short)33, (short)1);
        cachedSrv.ifPresent(c -> this.update(halo, (DnsRecord)c));
        Optional<DnsRecord> cachedTxt = halo.cachedRecord(serviceName, (short)16, (short)1);
        cachedTxt.ifPresent(c -> this.update(halo, (DnsRecord)c));
        if (this.hostname == null) {
            cachedIpV4 = Optional.empty();
            cachedIpV6 = Optional.empty();
        } else {
            cachedIpV4 = halo.cachedRecord(this.hostname, (short)1, (short)1);
            cachedIpV4.ifPresent(c -> this.update(halo, (DnsRecord)c));
            cachedIpV6 = halo.cachedRecord(this.hostname, (short)28, (short)1);
            cachedIpV6.ifPresent(c -> this.update(halo, (DnsRecord)c));
        }
        if (this.resolved()) {
            return true;
        }
        Queue<Duration> delays = this.delays(timeout);
        halo.addResponseListener(this);
        try {
            while (!this.resolved() && !delays.isEmpty()) {
                Optional<Instant> now = Optional.of(halo.now());
                DnsMessage.Builder builder = DnsMessage.query(new short[0]);
                builder.addQuestion(new DnsQuestion(serviceName, 33, 1));
                cachedSrv.ifPresent(r -> builder.addAnswer((DnsRecord)r, now));
                builder.addQuestion(new DnsQuestion(serviceName, 16, 1));
                cachedTxt.ifPresent(r -> builder.addAnswer((DnsRecord)r, now));
                if (this.hostname != null) {
                    builder.addQuestion(new DnsQuestion(this.hostname, 1, 1));
                    cachedIpV4.ifPresent(r -> builder.addAnswer((DnsRecord)r, now));
                    builder.addQuestion(new DnsQuestion(this.hostname, 28, 1));
                    cachedIpV6.ifPresent(r -> builder.addAnswer((DnsRecord)r, now));
                }
                halo.sendMessage(builder.get());
                this.awaitResolution(delays.poll());
            }
        }
        finally {
            halo.removeResponseListener(this);
        }
        return this.resolved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitResolution(Duration dur) throws InterruptedException {
        this.lock.lock();
        this.awaitingResolution = true;
        boolean response = false;
        try {
            Timeout timeout = Timeout.ofDuration(dur);
            Duration remaining = timeout.remaining();
            while (this.awaitingResolution && !remaining.isZero()) {
                response = this.resolved.await(remaining.toMillis(), TimeUnit.MILLISECONDS);
                remaining = timeout.remaining();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!response) {
            LOGGER.fine(() -> "No response received within " + dur);
        }
    }

    private Queue<Duration> delays(Duration timeout) {
        ArrayDeque<Duration> result = new ArrayDeque<Duration>();
        if (timeout.compareTo(HaloProperties.RESOLUTION_INTERVAL) <= 0) {
            return result;
        }
        int factor = 1;
        Duration delay = HaloProperties.RESOLUTION_INTERVAL;
        Duration total = Duration.ZERO;
        do {
            result.add(delay);
        } while ((total = total.plus(delay)).plus(delay = HaloProperties.RESOLUTION_INTERVAL.multipliedBy(factor *= 2)).compareTo(timeout) <= 0);
        delay = timeout.minus(total);
        if (!delay.isZero()) {
            result.add(delay);
        }
        return result;
    }

    private boolean resolved() {
        return this.hostname != null && (this.ipv4Address.isPresent() || this.ipv6Address.isPresent()) && this.attributes != null;
    }

    private void update(HaloHelper halo, DnsRecord record) {
        if (record.isExpired(halo.now())) {
            LOGGER.info(() -> "Ignored expired " + record);
        } else {
            String serviceName = this.name();
            boolean matchesService = record.name().equalsIgnoreCase(serviceName);
            boolean matchesHost = record.name().equalsIgnoreCase(this.hostname);
            if (record.type() == 1 && matchesHost) {
                this.ipv4Address = Optional.of((Inet4Address)((AddressRecord)record).address());
                LOGGER.fine(() -> "IPV4 address of service [" + serviceName + UPDATED_TO + this.ipv4Address.get());
            } else if (record.type() == 28 && matchesHost) {
                this.ipv6Address = Optional.of((Inet6Address)((AddressRecord)record).address());
                LOGGER.fine(() -> "Address of service [" + serviceName + UPDATED_TO + this.ipv6Address.get());
            } else if (record.type() == 33 && matchesService) {
                SrvRecord srv = (SrvRecord)record;
                this.port = srv.port();
                this.hostname = srv.server();
                LOGGER.fine(() -> "Port of service [" + serviceName + UPDATED_TO + this.port);
                LOGGER.fine(() -> "Server of service [" + serviceName + UPDATED_TO + this.hostname);
                halo.cachedRecord(this.hostname, (short)1, (short)1).ifPresent(r -> this.update(halo, (DnsRecord)r));
                halo.cachedRecord(this.hostname, (short)28, (short)1).ifPresent(r -> this.update(halo, (DnsRecord)r));
            } else if (record.type() == 16 && matchesService) {
                this.attributes = ((TxtRecord)record).attributes();
                LOGGER.fine(() -> "Attributes of service [" + serviceName + UPDATED_TO + this.attributes);
            } else {
                LOGGER.fine(() -> "Ignored irrelevant " + record);
            }
        }
    }
}

