/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import io.omam.halo.HaloThreadFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class SequentialBatchExecutor {
    private final ScheduledExecutorService executor;
    private final Map<String, FutureBatch> batches;
    private final Lock lock;

    SequentialBatchExecutor(String name) {
        this.executor = Executors.newSingleThreadScheduledExecutor(new HaloThreadFactory(name));
        this.batches = new HashMap<String, FutureBatch>();
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FutureBatch scheduleBatch(String name, Callable<Void> task, int size, Duration delay) throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            FutureBatch currentBatch = this.batches.get(name);
            if (currentBatch != null) {
                currentBatch.awaitAll();
            }
            Future<Void> first = this.executor.submit(task);
            ArrayList<ScheduledFuture<Void>> next = new ArrayList<ScheduledFuture<Void>>();
            for (int i = 1; i < size; ++i) {
                long currentDelay = (long)i * delay.toMillis();
                next.add(this.executor.schedule(task, currentDelay, TimeUnit.MILLISECONDS));
            }
            FutureBatch batch = new FutureBatch(first, next);
            this.batches.put(name, batch);
            FutureBatch futureBatch = batch;
            return futureBatch;
        }
        finally {
            this.lock.unlock();
        }
    }

    final void shutdownNow() {
        this.executor.shutdownNow();
    }

    static final class FutureBatch {
        private final Future<Void> first;
        private final Collection<ScheduledFuture<Void>> nexts;

        FutureBatch(Future<Void> aFirst, Collection<ScheduledFuture<Void>> someNexts) {
            this.first = aFirst;
            this.nexts = someNexts;
        }

        final void awaitAll() throws InterruptedException, ExecutionException {
            this.awaitFirst();
            for (ScheduledFuture<Void> next : this.nexts) {
                next.get();
            }
        }

        final void awaitFirst() throws InterruptedException, ExecutionException {
            this.first.get();
        }

        final void cancelAll() {
            this.first.cancel(true);
            this.nexts.forEach(f -> f.cancel(true));
        }
    }
}

