/*
 * Decompiled with CFR 0.152.
 */
package io.omam.halo;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

final class Timeout {
    private final Duration duration;
    private final long start;

    private Timeout(Duration initialDuration) {
        Objects.requireNonNull(initialDuration);
        this.duration = initialDuration;
        this.start = System.nanoTime();
    }

    static Timeout ofDuration(Duration initialDuration) {
        return new Timeout(initialDuration);
    }

    final Duration remaining() {
        long elapsedNs = System.nanoTime() - this.start;
        Duration remaining = this.duration.minus(elapsedNs, ChronoUnit.NANOS);
        if (remaining.isNegative()) {
            remaining = Duration.ZERO;
        }
        return remaining;
    }
}

