/*
 * Decompiled with CFR 0.152.
 */
package net.okihouse.autocomplete.implement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.okihouse.autocomplete.repository.AutocompleteKeyRepository;
import net.okihouse.autocomplete.repository.AutocompleteRepository;
import net.okihouse.autocomplete.vo.AutocompleteData;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.Assert;

public class AutocompleteServiceImpl
implements AutocompleteRepository {
    private final double min = 0.0;
    private final double max = 5.0;
    private final int offset = 30;
    private StringRedisTemplate stringRedisTemplate;
    private AutocompleteKeyRepository keyRepository;

    public AutocompleteServiceImpl(StringRedisTemplate stringRedisTemplate, AutocompleteKeyRepository keyRepository) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.keyRepository = keyRepository;
    }

    @Override
    public List<AutocompleteData> complete(String word) {
        return this.complete(word, 0.0, 5.0, 30);
    }

    @Override
    public List<AutocompleteData> complete(String word, double min, double max, int offset) {
        Assert.hasLength((String)word, (String)"Word cannot be empty or null");
        String trimedWord = word.trim();
        int trimedWordLength = trimedWord.length();
        String key = this.keyRepository.getKey(trimedWord);
        ArrayList<AutocompleteData> autocompletes = new ArrayList<AutocompleteData>();
        block0: for (int i = trimedWordLength; i < offset && autocompletes.size() != offset; ++i) {
            Set rangeResultsWithScore = this.stringRedisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)(key + i), min, max, 0L, (long)offset);
            if (rangeResultsWithScore.isEmpty()) continue;
            for (ZSetOperations.TypedTuple typedTuple : rangeResultsWithScore) {
                if (autocompletes.size() == offset) continue block0;
                String value = (String)typedTuple.getValue();
                int minLength = Math.min(value.length(), trimedWordLength);
                if (!value.endsWith("\u00a7") || !value.startsWith(trimedWord.substring(0, minLength))) continue;
                autocompletes.add(new AutocompleteData(value.replace("\u00a7", ""), typedTuple.getScore().intValue()));
            }
        }
        Collections.sort(autocompletes);
        return autocompletes;
    }

    @Override
    public void add(String word) {
        this.keyRepository.create(word, "\u00a7");
    }

    @Override
    public double incr(String word) {
        return this.keyRepository.incr(word, "\u00a7");
    }

    @Override
    public void clear(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }
}

