/*
 * Decompiled with CFR 0.152.
 */
package net.okihouse.autocomplete.key;

import net.okihouse.autocomplete.repository.AutocompleteKeyRepository;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Assert;

public class AutocompleteKeyServiceImpl
implements AutocompleteKeyRepository {
    protected static final String DELIMITER = ":";
    protected static final String PREFIX = "autocomplete:";
    private StringRedisTemplate stringRedisTemplate;

    public AutocompleteKeyServiceImpl(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public String create(String word, String identifier) {
        Assert.hasLength((String)word, (String)"Word cannot be empty or null");
        String trimedWord = word.trim();
        String firstLetter = this.getPrefix(trimedWord);
        String generatedKey = this.generateKey(firstLetter, trimedWord.length());
        if (!this.hasKey(generatedKey, trimedWord, identifier)) {
            this.stringRedisTemplate.opsForZSet().add((Object)generatedKey, (Object)(trimedWord + identifier), 1.0);
            this.stringRedisTemplate.opsForZSet().add((Object)generatedKey, (Object)firstLetter, 0.0);
            for (int index = 1; index < trimedWord.length(); ++index) {
                this.stringRedisTemplate.opsForZSet().add((Object)generatedKey, (Object)trimedWord.substring(0, index - 1), 0.0);
            }
        }
        return generatedKey;
    }

    @Override
    public String getKey(String word) {
        String firstLetter = this.getPrefix(word);
        return this.generateKeyWithoutLength(firstLetter);
    }

    @Override
    public double incr(String word, String identifier) {
        Assert.hasLength((String)word, (String)"Word cannot be empty or null");
        String trimedWord = word.trim();
        String firstLetter = this.getPrefix(trimedWord);
        String generatedKey = this.generateKey(firstLetter, trimedWord.length());
        if (!this.hasKey(generatedKey, trimedWord, identifier)) {
            return 0.0;
        }
        return this.stringRedisTemplate.opsForZSet().incrementScore((Object)generatedKey, (Object)(trimedWord + identifier), 1.0);
    }

    private String generateKey(String firstLetter, int length) {
        return this.generateKeyWithoutLength(firstLetter) + length;
    }

    private String generateKeyWithoutLength(String firstLetter) {
        return PREFIX + firstLetter + DELIMITER;
    }

    private boolean hasKey(String key, String word, String identifier) {
        Double exist = this.stringRedisTemplate.opsForZSet().score((Object)key, (Object)(word.trim() + identifier));
        return exist != null;
    }

    private String getPrefix(String word) {
        return word.substring(0, 1);
    }
}

