/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.robotframework.remoteserver.cli.CommandLineHelper;
import org.robotframework.remoteserver.logging.Jetty2Log4J;
import org.robotframework.remoteserver.servlet.RemoteServerServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServer {
    private static org.apache.commons.logging.Log log = LogFactory.getLog(RemoteServer.class);
    private Server server;
    protected Map<Integer, Class<?>> libraryMap = new HashMap();
    private boolean allowStop = true;
    private String host = null;
    private List<SelectChannelConnector> connectors = new ArrayList<SelectChannelConnector>();

    public boolean getAllowStop() {
        return this.allowStop;
    }

    public void setAllowStop(boolean allowed) {
        this.allowStop = allowed;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String hostName) {
        this.host = hostName;
    }

    public static void main(String[] args) throws Exception {
        RemoteServer.configureLogging();
        CommandLineHelper helper = new CommandLineHelper(args);
        if (helper.getHelpRequested()) {
            System.out.print(helper.getUsage());
            System.exit(0);
        } else if (helper.getError() != null) {
            System.out.println(helper.getError());
            System.out.println();
            System.out.println(helper.getUsage());
            System.exit(1);
        }
        RemoteServer remoteServer = new RemoteServer();
        for (int port : helper.getLibraryMap().keySet()) {
            remoteServer.addLibrary(helper.getLibraryMap().get(port), port);
        }
        remoteServer.setAllowStop(helper.getAllowStop());
        remoteServer.setHost(helper.getHost());
        remoteServer.start();
    }

    public void addLibrary(String className, int port) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to load class %s", className), e);
        }
        this.addLibrary(clazz, port);
    }

    public void addLibrary(Class<?> clazz, int port) {
        if (this.server != null && !this.server.isStopped()) {
            throw new IllegalStateException("Cannot add a library once the server is started");
        }
        if (this.libraryMap.containsKey(port)) {
            throw new IllegalStateException(String.format("A library was already added for port %d", port));
        }
        this.libraryMap.put(port, clazz);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        connector.setName("jrobotremotesever");
        this.connectors.add(connector);
        log.info((Object)String.format("Added library %s", clazz.getName()));
    }

    public void stop(int timeoutMS) throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("The server was never started");
        }
        log.info((Object)"Robot Framework remote server stopping");
        if (timeoutMS > 0) {
            this.server.setGracefulShutdown(timeoutMS);
            Thread stopper = new Thread(){

                public void run() {
                    try {
                        RemoteServer.this.server.stop();
                    }
                    catch (Throwable e) {
                        log.error((Object)String.format("Failed to stop the server: %s", e.getMessage()), e);
                    }
                }
            };
            stopper.start();
        } else {
            this.server.stop();
        }
    }

    public void stop() throws Exception {
        this.stop(0);
    }

    public void start() throws Exception {
        if (this.server == null) {
            this.server = new Server();
        }
        if (this.connectors.isEmpty()) {
            throw new IllegalStateException("Cannot start the server without adding a library first");
        }
        if (!this.server.isStopped()) {
            throw new IllegalStateException("The server is starting or already started");
        }
        for (SelectChannelConnector conn : this.connectors) {
            conn.setHost(this.host);
        }
        this.server.setConnectors(this.connectors.toArray(new Connector[0]));
        ServletContextHandler servletContextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", false, false);
        servletContextHandler.addServlet(new ServletHolder(this.createServlet()), "/");
        this.libraryMap.clear();
        log.info((Object)"Robot Framework remote server starting");
        this.server.start();
        this.connectors.clear();
    }

    public static void configureLogging() {
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        root.removeAllAppenders();
        BasicConfigurator.configure();
        root.setLevel(Level.INFO);
        Log.setLog((Logger)new Jetty2Log4J());
        LogFactory.releaseAll();
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.Log4JLogger");
        log = LogFactory.getLog(RemoteServer.class);
    }

    protected Servlet createServlet() {
        return new RemoteServerServlet(this, this.libraryMap);
    }
}

