/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.cli;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineHelper {
    private Map<Integer, String> libraryMap = new HashMap<Integer, String>();
    private boolean allowStop = true;
    private String host = null;
    private String error = null;
    private boolean helpRequested = false;
    private String[] args;
    private int idx = 0;

    public boolean getAllowStop() {
        return this.allowStop;
    }

    public String getHost() {
        return this.host;
    }

    public Map<Integer, String> getLibraryMap() {
        return this.libraryMap;
    }

    public String getError() {
        return this.error;
    }

    public boolean getHelpRequested() {
        return this.helpRequested;
    }

    public String getUsage() {
        return "Usage:  org.robotframework.remoteserver.RemoteServer options\n\nOptions:\n    -l --library classname:port   test library to serve (can be repeated)\n    -a --allowstop true|false     whether to allow remote stop\n    -H --host hostname            hostname of the interface to bind to\n    -h -? --help                  print this help message";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandLineHelper(String[] clargs) {
        this.args = clargs;
        try {
            while (this.idx < this.args.length) {
                if (this.args[this.idx].equals("-l") || this.args[this.idx].equals("--library")) {
                    int port;
                    String[] parts = this.getValue("library").split(":");
                    if (parts.length != 2) {
                        throw new RuntimeException("Value for library must be in the format classname:port");
                    }
                    try {
                        port = Integer.valueOf(parts[1].trim());
                        if (port < 1 || port > 65535) {
                            throw new Exception();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Port must be 1-65535");
                    }
                    if (this.libraryMap.containsKey(port)) {
                        throw new RuntimeException("Cannot serve more than one library from the same port");
                    }
                    this.libraryMap.put(port, parts[0].trim());
                } else if (this.args[this.idx].equals("-H") || this.args[this.idx].equals("--host")) {
                    this.host = this.getValue("host");
                } else if (this.args[this.idx].equals("-a") || this.args[this.idx].equals("--allowstop")) {
                    String value = this.getValue("allowstop");
                    if (value.equalsIgnoreCase("false")) {
                        this.allowStop = false;
                    } else {
                        if (!value.equalsIgnoreCase("true")) throw new RuntimeException("Value for option allowstop must be true or false");
                        this.allowStop = true;
                    }
                } else {
                    if (!Arrays.asList("-h", "-?", "--help").contains(this.args[this.idx])) throw new RuntimeException("Unkown option: " + this.args[this.idx]);
                    this.helpRequested = true;
                    return;
                }
                ++this.idx;
            }
            if (!this.libraryMap.isEmpty()) return;
            throw new RuntimeException("You must specify at least one library");
        }
        catch (Exception e) {
            this.error = e.getMessage();
        }
    }

    private String getValue(String name) {
        if (this.idx == this.args.length - 1 || this.args[this.idx + 1].startsWith("-")) {
            throw new RuntimeException("Missing value for option " + name);
        }
        return this.args[this.idx++ + 1];
    }
}

