/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.javalib;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.robotframework.javalib.beans.annotation.IKeywordExtractor;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.reflection.IKeywordInvoker;
import org.robotframework.javalib.reflection.KeywordInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleKeywordExtractor
implements IKeywordExtractor<Keyword> {
    public Map<String, Keyword> extractKeywords(Object keywordBean) {
        Method[] methods;
        HashMap<String, Keyword> extractedKeywords = new HashMap<String, Keyword>();
        for (Method method : methods = keywordBean.getClass().getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isPublic(method.getModifiers())) continue;
            Keyword keyword = this.createKeyword(keywordBean, method);
            String methodName = method.getName();
            if (extractedKeywords.containsKey(methodName)) {
                throw new RuntimeException("Overloaded method with name '" + methodName + "' found!");
            }
            extractedKeywords.put(method.getName(), keyword);
        }
        return extractedKeywords;
    }

    IKeywordInvoker createKeywordInvoker(Object keywordBean, Method method) {
        return new KeywordInvoker(keywordBean, method);
    }

    private Keyword createKeyword(Object keywordBean, Method method) {
        IKeywordInvoker keywordInvoker = this.createKeywordInvoker(keywordBean, method);
        return this.createKeyword(keywordInvoker);
    }

    private Keyword createKeyword(final IKeywordInvoker keywordInvoker) {
        return new Keyword(){

            public Object execute(Object[] arguments) {
                return keywordInvoker.invoke(arguments);
            }
        };
    }
}

